<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'adddevices';
        $this->shcontrollname = 'adddevices';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'programesetting'; //controller name or tab name
        $active[1] = 'adddevices'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("visits_common.php"); //general functions
//here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

//find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

#################################################################### Heba : ## get all investigation category ##############################################################################
        $devices = R::findall('devices', 'deleted != 1 ');
        $this->smarty->assign('devices', $devices);

        $floors = R::findAll('floors', ' deleted != 1 ');
        $this->smarty->assign('floors', $floors);

        $rooms = R::findAll('operations_rooms', ' deleted != 1 ');
        $this->smarty->assign('rooms', $rooms);

        $locations = R::findAll('locations', ' deleted != 1 order by id asc  ');
        $this->smarty->assign('locations', $locations);
################################################################################################################################################################################
//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addnewdevice() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $device = R::dispense('devices');
        $device->device_name = "";
        $device->location = 0;
        $device->deleted = 0;
        try {
            $device->id = R::store($device);

            $floors = R::findAll('floors', ' deleted != 1 ');
            $this->smarty->assign('floors', $floors);

            $rooms = R::findAll('operations_rooms', ' deleted != 1 ');
            $this->smarty->assign('rooms', $rooms);

            $locations = R::findAll('locations', ' deleted != 1 order by id asc ');
            $this->smarty->assign('locations', $locations);

            $this->smarty->assign('device', $device);
            $this->smarty->display('adddevices/device.html');
            echo $id;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function update() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        try {
            $obj = R::load($tablename, $id);

            $obj->$colname = $value;

            if ($tablename == 'archive_request' && ($colname == 'request_note' || $colname == 'receive_note')) {
                $colname2 = $colname . '_userid';
                $obj->$colname2 = $_SESSION['user_id'];
            }
            R::store($obj);

//header('Location:' . $this->hosturl . '/controllers/' . $this->controllname.'.php?ac=index' );
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function tracking_report() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################
        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));
##############################################################################
//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/tracking_report.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function tracking_search() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $date = filter_input(INPUT_POST, 'date');
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');

##############################################################################

        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
            $this->trackingSearchPatient($patientId);
            $this->smarty->display('adddevices/tracking_Patient.html');
        } else {
            $this->trackingSearchAll($date);
            $this->smarty->display('adddevices/tracking_search.html');
        }
    }

    function trackingSearchPatient($patientId) {

        $sql = 'select distinct  locations.id  as locationId   ,  locations. name  as locationName 
                   from    devices
                               join  locations                         on  locations.id = devices.location 
                               join  device_tracking                         on  device_tracking.device_id = devices.id        
                         where device_tracking.deleted = 0      and device_tracking.patient_id = ' . $patientId . '    ';


        $locations = R::getAll($sql);

        $x = 0;
        foreach ($locations as $location) {
            $sql = 'select distinct  devices.floor_no  as floorId   ,  floors. name  as floorName 
                   from    devices
                               join  floors                                           on  floors.id = devices.floor_no 
                               join  device_tracking                         on  device_tracking.device_id = devices.id        
                         where device_tracking.deleted = 0  and devices.location = ' . $location['locationId'] . '      
                         and device_tracking.patient_id = ' . $patientId . '  order by  floorId asc    ';


            $floors = R::getAll($sql);

//            print_r('<pre>');
//            print_r($floors);
//            print_r('</pre>');

            $locations[$x]['floors'] = $floors;
            $locations[$x]['floorsCount'] = count($floors);
            $x++;
        }
        $this->smarty->assign('locations', $locations);



        $sql = 'select  patients.id as  patient_id  , patients.wifename 
                                        , patients.husdandname      , patients.statusno
                                       from    patients
                         where patients.id =  ' . $patientId . '    ';

        $patient = R::getRow($sql);

        $sql = 'select distinct  device_tracking.visit_date  
                   from    device_tracking
                               join  patients                               on  patients.id = device_tracking.patient_id    
                         where device_tracking.deleted = 0 and       device_tracking.patient_id = ' . $patientId . '     
                                         order by device_tracking.visit_date   desc ';


        $dates = R::getAll($sql);

        $i = 0;
        foreach ($dates as $date) {
            $res = array();
            foreach ($locations as $location) {
                foreach ($location['floors'] as $location_floor) {
                    $fff = '';

//     r::debug(true, 2);
                    $sql = 'select      TIME_FORMAT(device_tracking.visit_time, "%h:%i %p") as  visit_time
                   from    device_tracking
                    join  devices                         on  device_tracking.device_id = devices.id        
                         where device_tracking.deleted = 0   and device_tracking.patient_id = ' . $patient['patient_id'] . '  
                         and devices.location  = ' . $location['locationId'] . '  
                         and devices.floor_no  = ' . $location_floor['floorId'] . ' 
                          and device_tracking.visit_date = "' . $date['visit_date'] . '"    ';

                    $records = R::getAll($sql);
                    $c = 1;
                    foreach ($records as $record) {
                        if ($c > 1) {
                            $fff .= ' <br> ';
                        }
                        $fff .= $record['visit_time'];
                        $c++;
                    }
                    array_push($res, $fff);
                }
            }

            $dates[$i]['records'] = $res;
            $i++;
        }
        $this->smarty->assign('patient', $patient);

//        print_r('<pre>');
//        print_r($dates);
//        print_r('</pre>');

        $this->smarty->assign('dates', $dates);
    }

    function trackingSearchAll($date) {

        $sql = 'select distinct  locations.id  as locationId   ,  locations. name  as locationName 
                   from    devices
                               join  locations                         on  locations.id = devices.location 
                               join  device_tracking                         on  device_tracking.device_id = devices.id        
                         where device_tracking.deleted = 0      and device_tracking.visit_date = "' . $date . '"    ';


        $locations = R::getAll($sql);

        $x = 0;
        foreach ($locations as $location) {
            $sql = 'select distinct  devices.floor_no  as floorId   ,  floors. name  as floorName 
                   from    devices
                               join  floors                                           on  floors.id = devices.floor_no 
                               join  device_tracking                         on  device_tracking.device_id = devices.id        
                         where device_tracking.deleted = 0  and devices.location = ' . $location['locationId'] . '      
                         and device_tracking.visit_date = "' . $date . '" order by  floorId asc    ';


            $floors = R::getAll($sql);

//            print_r('<pre>');
//            print_r($floors);
//            print_r('</pre>');

            $locations[$x]['floors'] = $floors;
            $locations[$x]['floorsCount'] = count($floors);
            $x++;
        }
        $this->smarty->assign('locations', $locations);

        $sql = 'select distinct  device_tracking.patient_id  , patients.wifename 
                                        , patients.husdandname      , patients.statusno
                   from    device_tracking
                               join  patients                               on  patients.id = device_tracking.patient_id    
                         where device_tracking.deleted = 0      and device_tracking.visit_date = "' . $date . '"   
                                         order by patients.statusno ';


        $patients = R::getAll($sql);

        $i = 0;
        foreach ($patients as $patient) {
            $res = array();
            foreach ($locations as $location) {
                foreach ($location['floors'] as $location_floor) {
                    $fff = '';

//     r::debug(true, 2);
                    $sql = 'select      TIME_FORMAT(device_tracking.visit_time, "%h:%i %p") as  visit_time
                   from    device_tracking
                    join  devices                         on  device_tracking.device_id = devices.id        
                         where device_tracking.deleted = 0   and device_tracking.patient_id = ' . $patient['patient_id'] . '  
                         and devices.location  = ' . $location['locationId'] . '  
                         and devices.floor_no  = ' . $location_floor['floorId'] . ' 
                          and device_tracking.visit_date = "' . $date . '"    ';

                    $records = R::getAll($sql);
                    $c = 1;
                    foreach ($records as $record) {
                        if ($c > 1) {
                            $fff .= ' <br> ';
                        }
                        $fff .= $record['visit_time'];
                        $c++;
                    }
                    array_push($res, $fff);
                }
            }
            $patients[$i]['records'] = $res;
            $i++;
        }
        $this->smarty->assign('patients', $patients);
    }

    public function go_to() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $patientNo = filter_input(INPUT_GET, 'patientNo');
        $deviceNo = filter_input(INPUT_GET, 'deviceId');

        if ($patientNo > 0) {
            $patientId = getPatientId($patientNo);
        }

        if ($deviceNo > 0) {
            $deviceId = getDeviceId($deviceNo);
        }

        if ($deviceId > 0 && $patientId > 0) {
            saveTrackingRecord($patientId, $deviceId, 0, '', 'clinics');
            setVisitsViewed($patientId);
        }

        if ($patientId > 0) {
            $lastVisit = R::findOne('lastvisit', 'patientid = ?', [$patientId]);
            if (!empty($lastVisit)) {
                header('Location:' . $this->hosturl . '/controllers/' . $lastVisit->control . '.php?ac=index&patientid=' . $patientId);
            } else {
                header('Location:' . $this->hosturl . '/controllers/patienthistory.php?ac=show&patientid=' . $patientId);
            }
        }
    }

    public function del() {

//check login
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");

        try {
            $table_obj = R::load($tableName, $id);
            $table_obj->deleted = 1;
            if ($tableName == "manual_operation") {
                $table_obj->delete_userid = $_SESSION['user_id'];
                $table_obj->delete_date = date('Y-m-d H:i:s');
            }
            R::store($table_obj);

            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

###########################################################

    public function external_labs() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));




        $role = R::load('awrole', $_SESSION['role_id']);
        $this->smarty->assign('ext_lab', $role->external_lab);

        if ($role->external_lab > 0) {
            $external_labs = R::findall('external_labs', 'deleted != ? and id = ?  ', [1, $role->external_lab]);
        } else {
            $external_labs = R::findall('external_labs', 'deleted != ? ', [1]);
        }
        $this->smarty->assign('external_labs', $external_labs);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/external_labs.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function external_search() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $external_lab = filter_input(INPUT_POST, 'external_lab');
        $idD = filter_input(INPUT_POST, 'idD');

##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }

        $role = R::load('awrole', $_SESSION['role_id']);
        $this->smarty->assign('ext_lab', $role->external_lab);

        $this->externalSearch($findate, $todate, $patientId, $external_lab, $idD);
        $this->smarty->display('adddevices/external_search.html');
    }

    function externalSearch($dateFrom, $dateTo, $patientId, $external_lab, $idD) {
        $externalLabs = array();
        $begin = new DateTime($dateFrom);
        $end = new DateTime($dateTo . ' +1 day');

        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);

        foreach ($period as $dt) {
            $dayDate = $dt->format("Y-m-d");
            $dayLabs = $this->externalSearchByDay($dayDate, $patientId, $external_lab, $idD);
            if (count($dayLabs) > 0) {
                $externalLabs[$dayDate] = $dayLabs;
            }
        }

        $this->smarty->assign('externalLabs', $externalLabs);
    }

    function externalSearchByDay($dayDate, $patientId, $external_lab, $idD) {
        $ext = '';
        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and visits.patientid = ' . $patientId;
        }

        if (!empty($external_lab) && $external_lab > 0) {
            $ext .= ' and investigationresults.external_lab = ' . $external_lab;
        }

        if ($idD == 1) {
            $ext .= ' and investigationresults.delivered = 1  ';
        } elseif ($idD == 2) {
            $ext .= ' and investigationresults.delivered != 1  ';
        }


        $sql = 'select distinct  investigationresults.id  as resId   ,  invests. name  as investName  
                              , patients.husdandname , patients.wifename  ,  patients.statusno  
                              ,  sender.name  as sendUserName  ,  receiver.name  as receiveUserName 
                              ,  external_labs.name  as labName , investigationresults.receive_userid 
                              , DATE(receive_date) as receive_date  , investigationresults.delivered 
                              , investigationresults.visitid   , investigationresults.pdf 
                              , investigationresults.delivered_userid  , DATE(delivered_date) as delivered_date
                               ,  deliver.name  as deliveredUserName  , investigationresults.receivername 
                               ,  lab.name  as labUserName    , DATE(lab_date) as lab_date  , investigationresults.lab_userid

                   from    investigationresults
                               join  visits                                              on  visits.id = investigationresults.visitid 
                               join  invests                                         on  invests.id = investigationresults.investid 
                                join  patients                                        on  patients.id = visits.patientid 
                                join  external_labs                         on  external_labs.id = investigationresults.external_lab 
                                left join awusers   sender                on sender.user_id = visits.user_id  
                                  left join awusers   receiver               on receiver.user_id = investigationresults.receive_userid  
                                left join awusers   lab               on lab.user_id = investigationresults.lab_userid  
                                left join awusers   deliver               on deliver.user_id = investigationresults.delivered_userid  
                                
                         where investigationresults.deleted = 0     and     visits.for_department  = 12 and    visits.deleted = 0  
                         and  (  invests.type = 1   || (investigationresults.sent = 1      and    invests.type != 1   )  )
                         and visits.visitdate   = "' . $dayDate . '"    ' . $ext . ' order by patients.statusno   asc  ';


        $dayLabs = R::getAll($sql);

        $x = 0;
        foreach ($dayLabs as $dayLab) {
            $paid = $this->checkVisitBalance($dayLab['visitid']);
            $dayLabs[$x]['paid'] = $paid;
            $x++;
        }

        return $dayLabs;
    }

    function checkVisitBalance($visitId) {
        $res = 1;
        $visit = R::load('visits', $visitId);
        if ($visit->restdetectionvalue > 0) {
            $payVisits = R::getRow('SELECT COALESCE(SUM(detectionvalue_cash),0)   as paid_cash 
                                                                 , COALESCE(SUM(detectionvalue_visa),0)   as paid_visa  
                                                                  , COALESCE(SUM(discount),0)   as paid_discount 
                                                                 , 0 as paid   
                                    FROM visits   where   deleted != ? and detectionid = 999 and visitid = ?   ', [1, $visitId]);

            $paid = $payVisits['paid_cash'] + $payVisits['paid_visa'];
            $dept = $visit->restdetectionvalue - $paid - $payVisits['paid_discount'];

            if ($dept > 0) {
                $res = 0;
            }
        }

        return $res;
    }

    public function receiveExternalTest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $resId = filter_input(INPUT_POST, 'resId');
        if ($resId > 0) {
            try {
                $inv = R::load('investigationresults', $resId);
                $inv->receive_userid = $_SESSION['user_id'];
                $inv->receive_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);

                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $res = '   <td> ' . $user['name'] . ' </td>
                            <td> ' . date('Y-m-d') . '</td>
                          ';

                echo $res;
            } catch (Exception $ex) {
                echo $ex;
            }
        } else {
            echo -1;
        }
    }

    public function deliverExternalTest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $resId = filter_input(INPUT_POST, 'resId');
        $dna = filter_input(INPUT_POST, 'dna');
        if ($resId > 0) {
            try {
                if ($dna == 1) {
                    $inv = R::load('dna_results', $resId);
                } else {
                    $inv = R::load('investigationresults', $resId);
                }
                $inv->delivered_userid = $_SESSION['user_id'];
                $inv->delivered_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);

                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $res = '   <td> ' . $user['name'] . ' </td>
                                                     <td> ' . date('Y-m-d') . '</td>
                               <td> <input type="text" class="form-control updateElement" data-id="' . $resId . '"   
                                       data-colName="receivername" 
                                       data-tableName="dna_results" value="" /> </td> ';

                echo $res;
            } catch (Exception $ex) {
                echo $ex;
            }
        } else {
            echo -1;
        }
    }

    public function labExternalTest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $resId = filter_input(INPUT_POST, 'resId');
        if ($resId > 0) {
            try {
                $inv = R::load('investigationresults', $resId);
                $inv->lab_userid = $_SESSION['user_id'];
                $inv->lab_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);

                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $res = '   <td> ' . $user['name'] . ' </td>
                            <td> ' . date('Y-m-d') . '</td>
                          ';

                echo $res;
            } catch (Exception $ex) {
                echo $ex;
            }
        } else {
            echo -1;
        }
    }

    public function printExternal() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $resId = filter_input(INPUT_POST, 'resId');
        if ($resId > 0) {
            try {
                $inv = R::getRow('SELECT    invests.name as invName   , sampletype.name as sampleType 
                                                                    , investigationresults.visitid   , investigationresults.date
                                                                FROM  investigationresults
                                                               join   invests     on  invests.id =  investigationresults.investid 
                                                                 left join sampletype            on sampletype.id = invests.sampletype
                                                              WHERE investigationresults.id  = ?  ', [$resId]);


                $visit = R::load('visits', $inv['visitid']);
                $patient = R::load('patients', $visit->patientid);

                if ($visit->for_husband == 1) {
                    $refer_doctor = $patient->h_doctor1;
                    $pat_name = $patient->husdandname;
                    $date = $patient->husbanddateofbirth;
                    $gender = 'Male';
                } elseif ($visit->for_husband == 2) {
                    $refer_doctor = $patient->doctor1;
                    $child = R::load('patients_childs', $visit->child);
                    $date = $child->birth_date;

                    if ($child->gender == 1) {
                        $gender = 'Male';
                    } else {
                        $gender = 'Female';
                    }

                    if (is_null($child->child_name) || $child->child_name == '') {
                        if ($child->gender == 1) {
                            $pat_name = 'الطفل / ' . $patient->wifename;
                        } else {
                            $pat_name = 'الطفلة / ' . $patient->wifename;
                        }
                    } else {
                        $pat_name = $child->child_name . '  /  ' . $patient->wifename;
                    }
                } else {
                    $refer_doctor = $patient->doctor1;
                    $pat_name = $patient->wifename;
                    $date = $patient->dateofbirth;
                    $gender = 'Female';
                }

                if ($refer_doctor > 0) {

                    $refer = R::getRow('select name from awusers where user_id = ?', [$refer_doctor]);
                    $refferDoctor = $refer['name'];
                } ##############
                else {
                    $refferDoctor = "لا يوجد ";
                }

                if ($date == '0000-00-00' || is_null($date) || $date == '') {
                    $age = 0;
                } else {
                    $dateWife = new DateTime($date);
                    $today1 = new DateTime(date('Y-m-d'));
                    $interval = $today1->diff($dateWife);
                }

                if ($interval->y > 0) {
                    $age = $interval->y . ' Years';
                } elseif ($interval->m > 0) {
                    $age = $interval->m . ' Months';
                } elseif ($interval->d > 0) {
                    $age = $interval->d . ' Days';
                }

                $this->smarty->assign('age', $age);
                $this->smarty->assign('patName', $pat_name);
                $this->smarty->assign('invName', $inv['invName']);
                $this->smarty->assign('gender', $gender);
                $this->smarty->assign('refferDoctor', $refferDoctor);
                $this->smarty->assign('sampleType', $inv['sampleType']);
                $this->smarty->assign('sampleDate', $inv['date']);


                $this->smarty->display('adddevices/print_external.html');
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

###########################################################

    public function lab_delivery() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/lab_delivery.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function lab_delivery_search() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $dna = filter_input(INPUT_POST, 'dna');

##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }

            if (empty($findate) || $findate == '' || empty($todate) || $todate == '') {
                $dates = $this->labDateBoundary($patientId);
                $dnaDates = $this->dnaDateBoundary($patientId);
            }

            if (empty($findate) || $findate == '') {
                if ($dates['findate'] > $dnaDates['findate'] && !empty($dnaDates['findate']) && $dnaDates['findate'] != '') {
                    $findate = $dnaDates['findate'];
                } elseif (!empty($dates['findate']) && $dates['findate'] != '') {
                    $findate = $dates['findate'];
                } else {
                    $findate = date("Y/m/d");
                }
            }

            if (empty($todate) || $todate == '') {
                if ($dates['todate'] > $dnaDates['todate'] && !empty($dates['todate']) && $dates['todate'] != '') {
                    $todate = $dates['todate'];
                } elseif (!empty($dnaDates['todate']) && $dnaDates['todate'] != '') {
                    $todate = $dnaDates['todate'];
                } else {
                    $todate = date("Y/m/d");
                }
            }
        }

        if ($dna == 1) {
            $this->dnaSearch($findate, $todate, $patientId);
        } else {
            $this->labDeliverySearch($findate, $todate, $patientId);
        }


        $this->smarty->display('adddevices/lab_delivery_search.html');
    }

    function labDateBoundary($patientId) {
        $sql = 'select    MAX(visits.visitdate) as todate , MIN(visits.visitdate) as findate
                   from    visits
                               join  investigationresults                                              on  visits.id = investigationresults.visitid 
                                join  patients                                        on  patients.id = visits.patientid 
                                
                         where       investigationresults.deleted = 0     
                         and           visits.for_department  = 12 
                         and           visits.deleted = 0  
                         and          visits.patientid = ' . $patientId;


        $dates = R::getRow($sql);
        return $dates;
    }

    function labDeliverySearch($dateFrom, $dateTo, $patientId) {
        $allLabs = array();

        $begin = new DateTime($dateTo . ' +1 day');
        $end = new DateTime($dateFrom);

        $interval = DateInterval::createFromDateString('1 day');

        while ($begin > $end) {
            $dayRes = array();
            $begin = $begin->sub($interval);
            $dayDate = $begin->format("Y-m-d");

            $dayLabs = $this->labDeliveryByDay($dayDate, $patientId);
            if (count($dayLabs) > 0) {
                $dayRes['labs'] = $dayLabs;
                $dayRes['labsCount'] = count($dayLabs);
            }

            $dayDna = $this->DnaByDay($dayDate, $patientId);
            if (count($dayDna) > 0) {
                $dayRes['dna'] = $dayDna;
                $dayRes['dnaCount'] = count($dayDna);
            }

            if (count($dayLabs) > 0 || count($dayDna) > 0) {
                $allLabs[$dayDate] = $dayRes;
            }
        }

        $this->smarty->assign('allLabs', $allLabs);
    }

    function labDeliveryByDay($dayDate, $patientId) {

        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and visits.patientid = ' . $patientId;
        }


        $sql = 'select distinct  investigationresults.id  as resId   ,  invests. name  as investName  
                              , patients.husdandname , patients.wifename  ,  patients.statusno  
                              ,  sender.name  as sendUserName  ,  receiver.name  as receiveUserName 
                              ,  external_labs.name  as labName , investigationresults.receive_userid 
                              , DATE(receive_date) as receive_date  , investigationresults.delivered 
                              , investigationresults.printed , investigationresults.verified , investigationresults.filled 
                              , investigationresults.visitid   , investigationresults.pdf 
                              , investigationresults.delivered_userid  , DATE(delivered_date) as delivered_date
                               ,  deliver.name  as deliveredUserName  , investigationresults.receivername 
                               ,   patients.id as patientId

                   from    investigationresults
                               join  visits                                              on  visits.id = investigationresults.visitid 
                               join  invests                                         on  invests.id = investigationresults.investid 
                                join  patients                                        on  patients.id = visits.patientid 
                                left join  external_labs                         on  external_labs.id = investigationresults.external_lab 
                                left join awusers   sender                on sender.user_id = visits.user_id  
                                  left join awusers   receiver               on receiver.user_id = investigationresults.receive_userid  
                                left join awusers   lab               on lab.user_id = investigationresults.lab_userid  
                                left join awusers   deliver               on deliver.user_id = investigationresults.delivered_userid  
                                
                         where investigationresults.deleted = 0     and     visits.for_department  = 12 and    visits.deleted = 0  
                         and visits.visitdate   = "' . $dayDate . '"    ' . $ext . ' order by patients.statusno   asc  ';


        $dayLabs = R::getAll($sql);

        $x = 0;
        foreach ($dayLabs as $dayLab) {
            $paid = $this->checkVisitBalance($dayLab['visitid']);
            $dayLabs[$x]['paid'] = $paid;
            $x++;
        }

        return $dayLabs;
    }

###########################################################

    public function to_lab() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $external_labs = R::findall('external_labs', 'deleted != ? ', [1]);
        $this->smarty->assign('external_labs', $external_labs);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/to_lab.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function to_search() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $external_lab = filter_input(INPUT_POST, 'external_lab');

##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }


        $this->toSearch($findate, $todate, $patientId, $external_lab);
        $this->smarty->display('adddevices/to_search.html');
    }

    function toSearch($dateFrom, $dateTo, $patientId, $external_lab) {
        $externalLabs = array();
        $begin = new DateTime($dateFrom);
        $end = new DateTime($dateTo . ' +1 day');

        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);

        foreach ($period as $dt) {
            $dayDate = $dt->format("Y-m-d");
            $dayLabs = $this->toSearchByDay($dayDate, $patientId, $external_lab);
            if (count($dayLabs) > 0) {
                $externalLabs[$dayDate] = $dayLabs;
            }
        }

        $this->smarty->assign('externalLabs', $externalLabs);
    }

    function toSearchByDay($dayDate, $patientId, $external_lab) {
        $ext = '';
        $balance = 0;
        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and visits.patientid = ' . $patientId;
        }

        if (!empty($external_lab) && $external_lab > 0) {
            $ext .= ' and investigationresults.external_lab = ' . $external_lab;
        }

        $sql = 'select distinct  investigationresults.id  as resId   ,  invests. name  as investName  
                              , patients.husdandname , patients.wifename  ,  patients.statusno  , visits.visitdate
                              ,  external_labs.name  as labName ,   investigationresults. lab_to_lab_price  as toLabPrice  
                               , DATE(investigationresults.lab_date) as sampleDate , investigationresults.lab_userid 

                   from    investigationresults
                               join  visits                                              on  visits.id = investigationresults.visitid 
                               join  invests                                         on  invests.id = investigationresults.investid 
                                join  patients                                        on  patients.id = visits.patientid 
                                join  external_labs                         on  external_labs.id = investigationresults.external_lab 
                                
                         where investigationresults.deleted = 0     and     visits.for_department  = 12 and    visits.deleted = 0  
                           and  (  invests.type = 1   || (investigationresults.sent = 1      and    invests.type != 1   )  )
                         and visits.visitdate   = "' . $dayDate . '"    ' . $ext . ' order by patients.statusno   asc  ';


        $dayLabs = R::getAll($sql);

        return $dayLabs;
    }

###########################################################

    function dnaDateBoundary($patientId) {
        $sql = 'select    MAX(visits.visitdate) as todate , MIN(visits.visitdate) as findate
                   from    visits
                              left  join  dna_results                                              on  visits.id = dna_results.visitid 
                                join  patients                                                   on  patients.id = visits.patientid 
                                
                         where     visits.detectionid  in ( 140 , 241 )  
                         and         visits.deleted = 0  
                         and         visits.patientid = ' . $patientId;


        $dates = R::getRow($sql);
        return $dates;
    }

    function DnaByDay($dayDate, $patientId) {

        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and visits.patientid = ' . $patientId;
        }


        $sql = 'select   visits.id  as visitid      ,  detections. title  as investName   , dna_results.id as dnaResultId
                              , patients.husdandname , patients.wifename  ,  patients.statusno  
                              ,  sender.name  as sendUserName  ,  receiver.name  as receiveUserName 
                              , dna_results.receive_userid    , dna_results.pdf 
                              , DATE(receive_date) as receive_date  , dna_results.delivered 
                              , dna_results.printed , dna_results.verified , dna_results.filled 
                              , dna_results.delivered_userid  , DATE(delivered_date) as delivered_date
                               ,  deliver.name  as deliveredUserName  , dna_results.receivername 

                   from    visits
                            left  join detections    on detections.id  =  visits.detectionid
                             left   join  dna_results                                              on  visits.id = dna_results.visitid 
                                join  patients                                        on  patients.id = visits.patientid 
                                left join awusers   sender                on sender.user_id = visits.user_id  
                                  left join awusers   receiver               on receiver.user_id = dna_results.receive_userid  
                                left join awusers   lab               on lab.user_id = dna_results.lab_userid  
                                left join awusers   deliver               on deliver.user_id = dna_results.delivered_userid  
                                
                         where    visits.detectionid  in ( 140 , 241 )        and    visits.deleted = 0  
                         and visits.visitdate   = "' . $dayDate . '"    ' . $ext . ' order by patients.statusno   asc  ';


        $dayLabs = R::getAll($sql);

        $x = 0;
        foreach ($dayLabs as $dayLab) {
            if (!($dayLab['dnaResultId'] > 0)) {
                $dnaResultId = $this->insertDnaResult($dayLab['visitid']);
                $dayLabs[$x]['dnaResultId'] = $dnaResultId;
            }
            $paid = $this->checkVisitBalance($dayLab['visitid']);
            $dayLabs[$x]['paid'] = $paid;
            $x++;
        }

        return $dayLabs;
    }

    function insertDnaResult($visitId) {
        $dna = R::xdispense('dna_results');
        $dna->date = date('Y-m-d');
        $dna->visitid = $visitId;

        $dna->id = R::store($dna);
        return $dna->id;
    }

    public function dna() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));
        $this->smarty->assign('dna', 1);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/lab_delivery.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function dnaSearch($dateFrom, $dateTo, $patientId) {
        $allLabs = array();

        $begin = new DateTime($dateFrom);
        $end = new DateTime($dateTo . ' +1 day');

        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);

        foreach ($period as $dt) {
            $dayRes = array();
            $dayDate = $dt->format("Y-m-d");

            $dayRes['labsCount'] = 0;


            $dayDna = $this->DnaByDay($dayDate, $patientId);
            if (count($dayDna) > 0) {
                $dayRes['dna'] = $dayDna;
                $dayRes['dnaCount'] = count($dayDna);
            }

            if (count($dayDna) > 0) {
                $allLabs[$dayDate] = $dayRes;
            }
        }

        $this->smarty->assign('allLabs', $allLabs);
    }

###########################################################

    public function archive_request() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $doctors = R::getAll('select awusers.user_id   , awusers.name   from     awusers     
                                                           join       awrole                                           on awusers.role_id  = awrole.id
                                                          where awusers.deleted != 1 and   awrole.is_doctor = 1');
        $this->smarty->assign('doctors', $doctors);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/archive_request.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function archive_request_search() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;

##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }


        $this->archiveRequestsSearch($findate, $todate, $patientId, $doctorId);
        $this->smarty->display('adddevices/archive_request_search.html');
    }

    function archiveRequestsSearch($dateFrom, $dateTo, $patientId, $doctorId) {
        $archives = array();

        $begin = new DateTime($dateTo . ' +1 day');
        $end = new DateTime($dateFrom);
        $interval = DateInterval::createFromDateString('1 day');

        while ($begin > $end) {
            $begin = $begin->sub($interval);
            $dayDate = $begin->format("Y-m-d");
            $dayLabs = $this->archiveSearchByDay($dayDate, $patientId, $doctorId);
            if (count($dayLabs) > 0) {
                $archives[$dayDate] = $dayLabs;
            }
        }
        $this->smarty->assign('archives', $archives);
    }

    function archiveSearchByDay($dayDate, $patientId, $doctorId) {

        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and archive_request.patient_id = ' . $patientId;
        }

        if (!empty($doctorId) && $doctorId > 0) {
            $ext .= ' and archive_request.doctor_id = ' . $doctorId;
        }


        $sql = 'select   archive_request.id     , archive_request.receive_note   , archive_request.request_note  
                            , archive_request.request_userid  ,  archive_request.ready_userid , archive_request.receive_userid  
                            , req.name as request_userName , red.name as ready_userName, rec.name as receive_userName   
                            , DATE_FORMAT(archive_request.request_date, "%c-%d  %h:%i %p") as  request_date 
                            , DATE_FORMAT(archive_request.ready_date, "%c-%d  %h:%i %p") as  ready_date 
                            , DATE_FORMAT(archive_request.receive_date, "%c-%d  %h:%i %p") as  receive_date 
                             , DATE_FORMAT(archive_request.return_date, "%c-%d  %h:%i %p") as  return_date 
                            , patients.husdandname  ,   patients.wifename    ,  patients.statusno , doc.name as docName  
                            , archive_request.visit_id    , archive_request.request_note_userid , ret.name as return_userName     
                            , archive_request.receive_note_userid    , archive_request.return_userid  
                            , cancel.name as cancel_userName

                   from    archive_request
                              left  join awusers  req                        on req.user_id   = archive_request.request_userid   
                              left  join awusers  red                        on red.user_id   = archive_request.ready_userid   
                              left  join awusers  rec                        on rec.user_id   = archive_request.receive_userid   
                              left  join awusers  ret                         on ret.user_id   = archive_request.return_userid   
                              left  join awusers  doc                        on doc.user_id   = archive_request.doctor_id   
                              left  join awusers  cancel                   on cancel.user_id   = archive_request.cancel_userid   
                             join patients                                on patients.id  = archive_request.patient_id
                                
                         where archive_request.deleted  != 1  
                         and DATE(archive_request.request_date)   = "' . $dayDate . '"    ' . $ext . '  
                       order by doc.name desc    ';

//  print_r($sql);


        $dayLabs = R::getAll($sql);

//        $x = 0;
//        foreach ($dayLabs as $dayLab) {
//            $paid = $this->checkVisitBalance($dayLab['visitid']);
//            $dayLabs[$x]['paid'] = $paid;
//            $x++;
//        }

        return $dayLabs;
    }

    public function archiveRequests() {
//check login
        autho::checkautho($this->hosturl);


        $sIndexColumn = "id";

##  DB table to use 
        $sTable = "archive_request";
        $aColumns = array('archive_request.id', 'archive_request.receive_note'
            , 'awusers.name as request_userName'
            , 'archive_request.ready_userid', 'archive_request.receive_userid'
            , ' DATE_FORMAT(archive_request.request_date, "%Y-%c-%d  %h:%i %p") as  request_date'
            , ' DATE_FORMAT(archive_request.receive_date, "%Y-%c-%d  %h:%i %p") as  receive_date'
            , 'patients.husdandname', 'patients.wifename', 'patients.statusno');
        $sJoin .= '  left  join awusers                          on awusers.user_id   = archive_request.request_userid ';
        $sJoin .= '    join patients                                on patients.id  = archive_request.patient_id';


// Indexed column (used for fast and accurate table cardinality)
## Paging 

        $sLimit = "";
        if (isset($_GET['iDisplayStart']) && $_GET['iDisplayLength'] != '-1') {
            $sLimit = "LIMIT " . intval($_GET['iDisplayStart']) . ", " .
                    intval($_GET['iDisplayLength']);
        }

## Ordering
        $sOrder = "ORDER BY  request_date desc";
        if (isset($_GET['iSortCol_0'])) {
            $sOrder = "ORDER BY  ";
            for ($i = 0; $i < intval($_GET['iSortingCols']); $i++) {
                if ($_GET['bSortable_' . intval($_GET['iSortCol_' . $i])] == "true") {
                    $sOrder .= $aColumns[intval($_GET['iSortCol_' . $i])] . "
                    " . ($_GET['sSortDir_' . $i] === 'asc' ? 'asc' : 'desc') . ", ";
                }
            }

            $sOrder = substr_replace($sOrder, "", -2);
            if ($sOrder == "ORDER BY") {
                $sOrder = "ORDER BY  request_date desc";
            } else {
                $sOrder .= ",  request_date desc";
            }
        }

## * Filtering
##* NOTE this does not match the built-in DataTables filtering which does it
##* word by word on any field. It's possible to do here, but concerned about efficiency
## * on very large tables, and MySQL's regex functionality is very limited

        $sWhere = "WHERE (";


        if (isset($_GET['sSearch']) && $_GET['sSearch'] != "") {

            for ($i = 0; $i < count($aColumns); $i++) {
                if (isset($_GET['bSearchable_' . $i]) && $_GET['bSearchable_' . $i] == "true") {
                    $sWhere .= $aColumns[$i] . " LIKE '%" . $_GET['sSearch'] . "%' OR ";
                }
            }

            $sWhere = substr_replace($sWhere, "", -3);
            $sWhere .= ' AND archive_request.deleted  != 1     ';
        } else {
            $sWhere .= '   archive_request.deleted  != 1       ';
        }

        $sWhere .= ' )';

## get data which will be presented in html
        $sQuery = "SELECT SQL_CALC_FOUND_ROWS " . str_replace(" , ", " ", implode(", ", $aColumns)) . " FROM  $sTable $sJoin $sWhere   $sOrder $sLimit ";

// print_r($sQuery);

        $rResult = R::getAll($sQuery);

## Data set length after filtering 
        $sQuery = "SELECT FOUND_ROWS()";

        $rResultFilterTotal = R::getAll($sQuery);
        $iFilteredTotal = $rResultFilterTotal[0];

        $aColumns = array('id', 'receive_note', 'request_userName', 'ready_userName'
            , 'receive_userName', 'request_date', 'receive_date', 'receive_userid'
            , 'husdandname', 'wifename', 'statusno', 'ready_userid');

## Total data set length 

        $sQuery = "SELECT $sIndexColumn FROM  $sTable ";
        $rResultTotal = R::getAll($sQuery);
//$aResultTotal = mysql_fetch_array($rResultTotal);
        $iTotal = count($rResultTotal);


## prepare json with form suitable for datable

        $output = array(
//"sEcho" => intval($_GET['sEcho']),
            "iTotalRecords" => $iTotal,
            "iTotalDisplayRecords" => $iFilteredTotal["FOUND_ROWS()"],
            "aaData" => array()
        );

        $i = 1;
        foreach ($rResult as $aRow) {
            $row = array();
// $row[] = $i;

            $row[] = $aRow['statusno'];

            $row[] = '  <ul>
                                    <li style="margin-left: 9px;">' . $aRow['wifename'] . '</li>
                                    <li>' . $aRow['husdandname'] . '</li>
                                </ul>';

            $row[] = $aRow['request_date'];

            $row[] = $aRow['request_userName'];

            if ($aRow['ready_userid'] > 0) {
                $row[] = ' <i class="fa fa-check "  id="readyCheck' . $aRow['id'] . '"
                                   style="color: #119866;font-size: 20px;margin-top: 5%;margin-bottom: 10%;"></i>  ';
            } else {
                $row[] = ' <a data-id="' . $aRow['id'] . '"  
                        class="btn blue-hoki btn-xs readyRequest"   id="readyRequest' . $aRow['id'] . '" >تم </a>';
            }

            if ($aRow['receive_userid'] > 0) {
                $row[] = $aRow['receive_date'];
                $row[] = '<input type="text" class="form-control updateElement" 
                    data-id="' . $aRow['id'] . '" data-colName="receive_note" 
                                       data-tableName="archive_request" value="' . $aRow['receive_note'] . '" /> ';
            } else {
                $row[] = '  <a data-id="' . $aRow['id'] . '"  
                        class="btn blue-hoki btn-xs receiveRequest"   id="receiveRequest' . $aRow['id'] . '" >تسليم </a>';
                $row[] = '';
            }



            $output['aaData'][] = $row;
            $i++;
        }
//        print_r($output);
        echo json_encode($output);
    }

    function archiveRequestAdd() {
//check login
        autho::checkautho($this->hosturl);

        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;

##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }

        if ($patientId > 0) {

            $exist = R::count('archive_request', ' patient_id = ? and  ready_userid = 0 and  visit_id = 0 ', [$patientId]);
            if ($exist > 0) {
                echo -2;
            } else {
                $obj = R::xdispense('archive_request');
                $obj->patient_id = $patientId;
                $obj->request_userid = $_SESSION['user_id'];
                $obj->request_date = date('Y-m-d H:i:s'); //$this->today;
                $obj->doctor_id = $doctorId;
                $obj->visit_id = 0;
                $obj->create_date = date('Y-m-d H:i:s');

                R::store($obj);
                echo 1;
            }
        }
    }

    public function readyRequest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        if ($id > 0) {
            try {
                $inv = R::load('archive_request', $id);
                $inv->ready_userid = $_SESSION['user_id'];
                $inv->ready_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);

                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);


                $result = array(
                    "ready_date" => date('m-d H:i A'),
                    "ready_userName" => $user['name']
                );

                echo json_encode($result);

//     echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function receiveRequest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        if ($id > 0) {
            try {
                $inv = R::load('archive_request', $id);
                $inv->receive_userid = $_SESSION['user_id'];
                $inv->receive_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);
                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $result = array(
                    "receive_date" => date('m-d H:i A'),
                    "receive_userName" => $user['name']
                );

                echo json_encode($result);

//   echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function cancelRequest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        if ($id > 0) {
            try {
                $inv = R::load('archive_request', $id);
                $inv->ready_userid = -1;
                $inv->cancel_userid = $_SESSION['user_id'];
                $inv->cancel_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);

                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $result = array(
                    "cancel_date" => date('m-d H:i A'),
                    "cancel_userName" => $user['name']
                );

                echo json_encode($result);

//     echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function returnRequest() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        if ($id > 0) {
            try {
                $inv = R::load('archive_request', $id);
                $inv->return_userid = $_SESSION['user_id'];
                $inv->return_date = date('Y-m-d H:i:s'); //$this->today;
                r::store($inv);

                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);


                $result = array(
                    "return_date" => date('m-d H:i A'),
                    "return_userName" => $user['name']
                );

                echo json_encode($result);
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function lostRequests() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $visits = R::findAll('visits', ' deleted = ? and   visitdate  >= ?  and  customer_add = 1 ', [0, date('Y-m-d')]);
        if (count($visits) > 0) {
            foreach ($visits as $visit) {
                $request = R::findOne('archive_request', ' visit_id = ? ', [$visit->id]);
                if (count($request) > 0) {
                    if ($request->patient_id != $visit->patientid || $request->doctor_id != $visit->for_doctor ||
                            date('Y-m-d', strtotime($request->request_date)) != $visit->visitdate) {
                        $this->updateReq($visit->id);
                    }
                } else {
                    $obj = R::xdispense('archive_request');
                    $obj->patient_id = $visit->patientid;
                    $obj->request_userid = $visit->user_id;
                    $obj->request_date = date($visit->visitdate . ' H:i:s');
                    $obj->doctor_id = $visit->for_doctor;
                    $obj->visit_id = $visit->id;
                    $obj->create_date = date('Y-m-d H:i:s');

                    R::store($obj);
                }
            }
        }
    }

    public function updateReq($visitId) {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $visit = R::load('visits', $visitId);
        $obj = R::findOne('archive_request', ' visit_id = ? ', [$visitId]);
        if (count($obj) > 0) {
            $obj->patient_id = $visit->patientid;
            $obj->request_date = date($visit->visitdate . ' H:i:s');
            $obj->doctor_id = $visit->for_doctor;
            $obj->update_date = date('Y-m-d H:i:s');

            R::store($obj);
        }
    }

    public function updateRequests() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################
        $visitId = filter_input(INPUT_GET, 'visitId');

        $visit = R::load('visits', $visitId);
        $obj = R::findOne('archive_request', ' visit_id = ? ', [$visitId]);
        if (count($obj) > 0) {
            $obj->patient_id = $visit->patientid;
            $obj->request_date = date($visit->visitdate . ' H:i:s');
            $obj->doctor_id = $visit->for_doctor;
            $obj->update_date = date('Y-m-d H:i:s');

            R::store($obj);
        }
    }

###########################################################

    public function externalLabs() {
        $id = filter_input(INPUT_POST, 'id');
        try {
            $invs = R::load('investigationresults', $id);
            $external_labs = R::findall('external_labs', 'deleted != ? ', [1]);
            $this->smarty->assign('external_labs', $external_labs);
            $this->smarty->assign('id', $id);
            $this->smarty->assign('external_lab', $invs->external_lab);
            $this->smarty->display('adddevices/externals.html');
        } catch (Exception $ex) {
            echo -1;
        }
    }

    public function cancelReceive() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $resId = filter_input(INPUT_POST, 'resId');
        $colName = filter_input(INPUT_POST, 'colName');
        $tableName = filter_input(INPUT_POST, 'tableName');
        $value = 0;
        if ($resId > 0) {
            try {
                $inv = R::load($tableName, $resId);
                $inv->$colName = $value;
                r::store($inv);

                echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

###########################################################

    public function dr_patients() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $doctors = R::getAll('select awusers.user_id   , awusers.name   from     awusers     
                                                           join       awrole                                           on awusers.role_id  = awrole.id
                                                          where awusers.deleted != 1 and   awrole.is_doctor = 1');
        $this->smarty->assign('doctors', $doctors);

        $detections = R::getAll('select  id , title from detections where del = 0');
        $this->smarty->assign('detections', $detections);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/dr_patients.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function dr_patients_search() {
//check login
        autho::checkautho($this->hosturl);
##############################################################################

        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $print = filter_input(INPUT_POST, 'print');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;
        $detection = filter_input(INPUT_POST, 'detection');
        $detect = json_decode($detection);
        sort($detect);
        $det = "";
        foreach ($detect as $myname) {
            $det = $det . $myname . ",";
        }
        $det = substr($det, 0, -1);

        $result = filter_input(INPUT_POST, 'result');
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }

##############################################################################
        $ext = '';
        if (!empty($det) && $det != "") {
            $ext .= ' and visits.detectionid in ( ' . $det . ' ) ';
        }

        if (!empty($doctorId) && $doctorId > 0) {
            $ext .= ' and visits.for_doctor = ' . $doctorId;
        }

        if (!empty($result) && $result > 0) {
            $ext .= ' and visits.result = ' . $result;
        } elseif ($result == -1) {
            $ext .= ' and visits.result not in (1  , 2 )   ';
        }

        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and visits.patientid = ' . $patientId;
        }


##############################################################################

        $this->drPatientsSearchAll($findate, $todate, $ext);
        if ($print == 1) {
            $this->smarty->display('adddevices/dr_patients_search_print.html');
        } else {
            $this->smarty->display('adddevices/dr_patients_search_all.html');
        }

//$this->drPatientsSearch($findate, $todate, $ext);
//        $this->smarty->display('adddevices/dr_patients_search.html');
    }

    function drPatientsSearch($dateFrom, $dateTo, $ext) {
        $archives = array();

        $begin = new DateTime($dateTo . ' +1 day');
        $end = new DateTime($dateFrom);
        $interval = DateInterval::createFromDateString('1 day');

        while ($begin > $end) {
            $begin = $begin->sub($interval);
            $dayDate = $begin->format("Y-m-d");
            $dayLabs = $this->drPatientsSearchByDay($dayDate, $ext);
            if (count($dayLabs) > 0) {
                $archives[$dayDate] = $dayLabs;
            }
        }
        $this->smarty->assign('archives', $archives);
    }

    function drPatientsSearchByDay($dayDate, $ext) {

        $sql = 'select   visits.id     , visits.visitdate     ,   detections.title as detectionType      , patients.statusno
                                , patients.wifename, patients.husdandname, patients.phone, patients.mobile
                                  , visits.dr_report_note
                   from    visits
                             join detections                          on detections.id   = visits.detectionid   
                             join patients                                on patients.id  = visits.patientid
                                
                         where visits.deleted  != 1  and  visits.for_department  = 13  and  visits.customer_add != 1
                         and visits.visitdate     = "' . $dayDate . '"    ' . $ext . '    ';

//  print_r($sql);
        $dayLabs = R::getAll($sql);
        return $dayLabs;
    }

    function drPatientsSearchAll($dateFrom, $dateTo, $ext) {

        $sql = 'select   visits.id     , visits.visitdate     ,   detections.title as detectionType      , patients.statusno
                                , patients.wifename, patients.husdandname, patients.phone, patients.mobile
                                  , visits.dr_report_note  , visits.result  ,  awusers.name  as drName
                   from    visits
                             join detections                         on detections.id   = visits.detectionid   
                             join patients                             on patients.id  = visits.patientid
                               left join awusers                    on awusers.user_id = visits.for_doctor  
                                
                         where visits.deleted  != 1    and  visits.customer_add != 1
                         and visits.visitdate >= "' . $dateFrom . '" AND visitdate <= "' . $dateTo . '"    ' . $ext . ' 
                          order by  visits.visitdate desc     ';

//  print_r($sql);
        $visits = R::getAll($sql);
        $this->smarty->assign('visitsAll', $visits);
        $this->smarty->assign('customResults', count($visits));


        $totalResults = R::count('visits', 'deleted  != 1  and  customer_add != 1    
                                                and visits.visitdate >= "' . $dateFrom . '" AND visitdate <= "' . $dateTo . '"       ');
        $this->smarty->assign('totalResults', $totalResults);
    }

###########################################################

    public function manual_operation() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $doctors = R::getAll('select awusers.user_id   , awusers.name   from     awusers     
                                                           join       awrole                                           on awusers.role_id  = awrole.id
                                                          where awusers.deleted != 1 and   awrole.is_doctor = 1');
        $this->smarty->assign('doctors', $doctors);

        $detections = R::getAll('select  id , title from detections where del = 0');
        $this->smarty->assign('detections', $detections);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/manual_operation.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function manualOperationAdd() {
//check login
        autho::checkautho($this->hosturl);

        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $date = filter_input(INPUT_POST, 'date');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;
        $detectionId = (filter_input(INPUT_POST, 'detection') > 0) ? filter_input(INPUT_POST, 'detection') : 0;

##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }

        if ($doctorId > 0 && $detectionId > 0) {

//            $visitId = 0;
//            if ($patientId > 0) {
//                $visit = r::getRow(' select id , p_exit  from visits where  patientid = ?  and visitdate = ?  
//                    and for_department = ? and deleted != 1 and for_doctor  = ?  and detectionid  = ? '
//                                , [$patientId, $date, 13, $doctorId, $detectionId]);
//                $visitId = $visit['id'];
//            }

            $obj = R::xdispense('manual_operation');
            $obj->patient_id = $patientId;
            $obj->doctor_id = $doctorId;
            $obj->detection_id = $detectionId;
            $obj->user_id = $_SESSION['user_id'];
            $obj->visit_id = 0;
            $obj->request_date = date($date . ' H:i:s'); // date('Y-m-d H:i:s');
            $obj->create_date = date('Y-m-d H:i:s');
//            if ($visitId > 0) {
//                $obj->case_exit = $visit['p_exit'];
//            }

            R::store($obj);
            echo 1;
        } else {
            echo -2;
        }
    }

    public function manual_operation_search() {
//check login
        autho::checkautho($this->hosturl);
##############################################################################
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $date = filter_input(INPUT_POST, 'date');
        $print = filter_input(INPUT_POST, 'print');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;
        $detection = (filter_input(INPUT_POST, 'detection') > 0) ? filter_input(INPUT_POST, 'detection') : 0;

        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }

##############################################################################
        $ext = '';
        if (!empty($detection) && $detection > 0) {
            $ext .= ' and manual_operation.detection_id = ' . $detection;
        }

        if (!empty($doctorId) && $doctorId > 0) {
            $ext .= ' and manual_operation.doctor_id = ' . $doctorId;
        }

        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and manual_operation.patient_id = ' . $patientId;
        }

##############################################################################
        $this->manualSearchBtns($_SESSION['role_id'], $print);
        $this->manualOperationSearchAll($date, $ext);
        if ($print == 1) {
            $this->smarty->display('adddevices/manual_operation_search_print.html');
        } else {
            $this->smarty->display('adddevices/manual_operation_search_all.html');
        }
    }

    function manualOperationSearchAll($date, $ext) {

        $sql = ' (  select   manual_operation.id    ,   detections.title as detectionType   , manual_operation.kashf_exit_userid     
                                , patients.wifename, patients.husdandname ,  awusers.name  as drName 
                                 , req.name as request_userName  ,  manual_operation.case_cost  , patients.statusno
                                   ,  manual_operation.case_note  , manual_operation.patient_id as patientId  
                                  ,  manual_operation.case_call   ,  "manual_operation"  as tableName  , 0 as minutes
                                  , DATE(manual_operation.request_date) as   request_date ,  manual_operation.detection_id   
                                  , manual_operation.patient_name as patientName  , manual_operation.status_no 
                                   , arrive.name as arrived_userName , enter.name as enter_userName
                                   , manual_operation.arrived_userid , manual_operation.enter_userid 
                                   , manual_operation.exit_userid ,  manual_operation.case_time  , manual_operation.doctor_id  
                                   , DATE_FORMAT(manual_operation.arrived_time, "%h:%i %p") as  arrived_time 
                                   , DATE_FORMAT(manual_operation.enter_time, "%h:%i %p") as  enter_time 
                                    , DATE_FORMAT(manual_operation.exit_time, "%h:%i %p") as  exit_time 
                                      , DATE_FORMAT(manual_operation.kashf_exit_time, "%h:%i %p") as  kashf_exit_time 
                                   
                   from    manual_operation
                             join detections                         on detections.id   = manual_operation.detection_id   
                            left  join patients                             on patients.id  = manual_operation.patient_id
                             left join awusers                      on awusers.user_id = manual_operation.doctor_id  
                             left  join awusers  req             on req.user_id   = manual_operation.user_id   
                               left  join awusers  arrive             on arrive.user_id   = manual_operation.arrived_userid   
                              left  join awusers  enter             on enter.user_id   = manual_operation.enter_userid    
                             left  join awusers  exitt                 on exitt.user_id   = manual_operation.exit_userid    
                                
                         where manual_operation.deleted  != 1     
                        AND DATE(manual_operation.request_date)  = "' . $date . '"    ' . $ext . '  )     ';

        $sql .= '   order by  request_date desc  ';


// print_r($sql);
        $visits = R::getAll($sql);

        $i = 0;
        foreach ($visits as $data) {
            if ($data['patientId'] > 0) {

                $visit = r::getRow(' select id , kashf_enterance  , res_enterance 
                                                        from visits where  patientid = ?  and visitdate = ?  
                                                                 and for_department = ? and deleted != 1 and for_doctor  = ?  
                                                                 and detectionid  = ? '
                                , [$data['patientId'], $date, 13, $data['doctor_id'], $data['detection_id']]);

                if (count($visit) > 0) {
                    $visits[$i]['kashfEnter'] = $visit['kashf_enterance'];
                    $visits[$i]['resEnter'] = $visit['res_enterance'];
                }
            }

            if ($data['arrived_time'] != "" && !( is_null($data['arrived_time'])) && $data['arrived_userid'] > 0 &&
                    $visits[$i]['resEnter'] != "" && !( is_null($visits[$i]['resEnter']))) {
                $date2 = new DateTime($data['arrived_time']);
                $date1 = new DateTime($visits[$i]['resEnter']);
                $interval = $date1->diff($date2);

                $minutes = $interval->days * 24 * 60;
                $minutes += $interval->h * 60;
                $minutes += $interval->i;
                $visits[$i]['minutes'] = $minutes;
//   $visits[$i]['minutes'] = $data['arrived_time'] . ' - ' . $visits[$i]['resEnter'] . ' - ' . $interval->days . ' - ' . $interval->h . ' - ' . $interval->i;
            }
            $i++;
        }

        $this->smarty->assign('visitsAll', $visits);

        $dayName = $this->getDayNameFnAr($date);
        $this->smarty->assign('dayName', $dayName);
        $this->smarty->assign('dayDate', date('Y/m/d', strtotime($date)));
    }

    function manualSearchBtns($roleId, $print) {
        $allowCostCol = 0;
        $btn14 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 14  ', [$roleId]);
        if (count($btn14) > 0) {
            $allowCostCol = $btn14->checkval;
        }
        $this->smarty->assign('allowCostCol', $allowCostCol);

        if ($print != 1) {
            $allowEditVisit = 0;
            $btn9 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 9  ', [$roleId]);
            if (count($btn9) > 0) {
                $allowEditVisit = $btn9->checkval;
            }
            $this->smarty->assign('allowEditVisit', $allowEditVisit);


            $allowDeleteVisit = 0;
            $btn10 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 10  ', [$roleId]);
            if (count($btn10) > 0) {
                $allowDeleteVisit = $btn10->checkval;
            }
            $this->smarty->assign('allowDeleteVisit', $allowDeleteVisit);

            $allowArriveBtn = 0;
            $btn11 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 11  ', [$roleId]);
            if (count($btn11) > 0) {
                $allowArriveBtn = $btn11->checkval;
            }
            $this->smarty->assign('allowArriveBtn', $allowArriveBtn);

            $allowRecEnterBtn = 0;
            $btn12 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 12  ', [$roleId]);
            if (count($btn12) > 0) {
                $allowRecEnterBtn = $btn12->checkval;
            }
            $this->smarty->assign('allowRecEnterBtn', $allowRecEnterBtn);

            $allowRecExitBtn = 0;
            $btn13 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 13  ', [$roleId]);
            if (count($btn13) > 0) {
                $allowRecExitBtn = $btn13->checkval;
            }
            $this->smarty->assign('allowRecExitBtn', $allowRecExitBtn);
        }
    }

    public function arrivedOperation() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        $mVisitId = filter_input(INPUT_POST, 'mVisitId');
        $editView = filter_input(INPUT_POST, 'editView');
        $save = 1;
        if ($editView == 1 && $mVisitId == $id) {
            $save = 0;
        }
        if ($id > 0 && $_SESSION['user_id'] > 0) {
            try {
                if ($save == 1) {
                    $inv = R::load('manual_operation', $id);
                    $inv->arrived_userid = $_SESSION['user_id'];
                    $inv->arrived_time = date('Y-m-d H:i:s'); //$this->today;
                    r::store($inv);
                }


                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);


                $result = array(
                    "date" => date('h:i A'),
                    "dateFull" => date('Y-m-d H:i:s'),
                    "userId" => $_SESSION['user_id'],
                    "userName" => $user['name']
                );

                echo json_encode($result);

//     echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function enterOperation() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        $mVisitId = filter_input(INPUT_POST, 'mVisitId');
        $editView = filter_input(INPUT_POST, 'editView');
        $save = 1;
        if ($editView == 1 && $mVisitId == $id) {
            $save = 0;
        }
        if ($id > 0) {
            try {

                if ($save == 1) {
                    $inv = R::load('manual_operation', $id);
                    $inv->enter_userid = $_SESSION['user_id'];
                    $inv->enter_time = date('Y-m-d H:i:s'); //$this->today;
                    r::store($inv);
                }


                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);


                $result = array(
                    "date" => date('h:i A'),
                    "dateFull" => date('Y-m-d H:i:s'),
                    "userId" => $_SESSION['user_id'],
                    "userName" => $user['name']
                );

                echo json_encode($result);

//     echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function exitOperation() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        $mVisitId = filter_input(INPUT_POST, 'mVisitId');
        $editView = filter_input(INPUT_POST, 'editView');
        $save = 1;
        if ($editView == 1 && $mVisitId == $id) {
            $save = 0;
        }
        if ($id > 0) {
            try {

                if ($save == 1) {
                    $inv = R::load('manual_operation', $id);
                    $inv->exit_userid = $_SESSION['user_id'];
                    $inv->exit_time = date('Y-m-d H:i:s'); //$this->today;
                    r::store($inv);
                }


                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $result = array(
                    "date" => date('h:i A'),
                    "dateFull" => date('Y-m-d H:i:s'),
                    "userId" => $_SESSION['user_id'],
                    "userName" => $user['name']
                );

                echo json_encode($result);

//     echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

    public function editManualOp() {

        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, "id");

        $manual_operation = R::load('manual_operation', $id);

        if (count($manual_operation) > 0) {
            $statusno = '';
            if ($manual_operation->patient_id > 0) {
                $patient = R::load('patients', $manual_operation->patient_id);
                $statusno = $patient->statusno;
            }
            $result = array(
                "statusno" => $statusno,
                "patientId" => $manual_operation->patient_id,
                "visitdate" => date("Y/m/d", strtotime($manual_operation->request_date)),
                "detectionId" => $manual_operation->detection_id,
                "doctorId" => $manual_operation->doctor_id,
                "arrived_userid" => $manual_operation->arrived_userid,
                "enter_userid" => $manual_operation->enter_userid,
                "exit_userid" => $manual_operation->exit_userid
            );

            echo json_encode($result);
        } else {
            echo -1;
        }
    }

    public function updateManualOp() {

        autho::checkautho($this->hosturl);

        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $date = filter_input(INPUT_POST, 'date');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;
        $detectionId = (filter_input(INPUT_POST, 'detection') > 0) ? filter_input(INPUT_POST, 'detection') : 0;
        $id = (filter_input(INPUT_POST, 'id') > 0) ? filter_input(INPUT_POST, 'id') : 0;

        $manualOperation = R::load('manual_operation', $id);
        $manualOperationOld = R::load('manual_operation', $id);

        $arrivedDateFull = filter_input(INPUT_POST, 'arrivedDateFull');
        $enterDateFull = filter_input(INPUT_POST, 'enterDateFull');
        $exitDateFull = filter_input(INPUT_POST, 'exitDateFull');
        $kashfExitDateFull = filter_input(INPUT_POST, 'kashfExitDateFull');

        $arrivedUserId = (filter_input(INPUT_POST, 'arrivedUserId') > 0) ? filter_input(INPUT_POST, 'arrivedUserId') : 0;
        $enterUserId = (filter_input(INPUT_POST, 'enterUserId') > 0) ? filter_input(INPUT_POST, 'enterUserId') : 0;
        $exitUserId = (filter_input(INPUT_POST, 'exitUserId') > 0) ? filter_input(INPUT_POST, 'exitUserId') : 0;
        $kashfExitUserId = (filter_input(INPUT_POST, 'kashfExitUserId') > 0) ? filter_input(INPUT_POST, 'kashfExitUserId') : 0;
##############################################################################
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }

        if ($doctorId > 0 && $detectionId > 0) {
            $manualOperation->patient_id = $patientId;
            $manualOperation->doctor_id = $doctorId;
            $manualOperation->detection_id = $detectionId;
            $manualOperation->user_id = $_SESSION['user_id'];
            $manualOperation->visit_id = 0;
            $manualOperation->request_date = date($date . ' H:i:s'); // date('Y-m-d H:i:s');
            if ($arrivedUserId > 0) {
                $manualOperation->arrived_userid = $arrivedUserId;
                $manualOperation->arrived_time = $arrivedDateFull; //$this->today;
            }

            if ($enterUserId > 0) {
                $manualOperation->enter_userid = $enterUserId;
                $manualOperation->enter_time = $enterDateFull; //$this->today;
            }

            if ($exitUserId > 0) {
                $manualOperation->exit_userid = $exitUserId;
                $manualOperation->exit_time = $exitDateFull; //$this->today;
            }

            if ($kashfExitUserId > 0) {
                $manualOperation->kashf_exit_userid = $kashfExitUserId;
                $manualOperation->kashf_exit_time = $kashfExitDateFull;
            }

            R::store($manualOperation);

            $this->reserveOldManualOp($manualOperationOld);
            echo 1;
        } else {
            echo -2;
        }
    }

    function reserveOldManualOp($oldManualOp) {
//check login
        autho::checkautho($this->hosturl);

        date_default_timezone_set('Africa/Cairo');

        $visitEdit = R::xdispense('manual_operation_updates');
        $colums = R::getAll('DESCRIBE manual_operation');

        foreach ($colums as $col) {
            $colName = $col['Field'];
            if ($colName != id) {
                $visitEdit->$colName = $oldManualOp->$colName;
            }
        }

        $visitEdit->update_userid = $_SESSION['user_id'];
        $visitEdit->update_date = date('Y-m-d H:i:s'); //$this->today;
        $visitEdit->original_id = $oldManualOp->id;
        R::store($visitEdit);
    }

    public function kashfExitOperation() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
//   autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
##############################################################################

        $id = filter_input(INPUT_POST, 'id');
        $mVisitId = filter_input(INPUT_POST, 'mVisitId');
        $editView = filter_input(INPUT_POST, 'editView');
        $save = 1;
        if ($editView == 1 && $mVisitId == $id) {
            $save = 0;
        }
        if ($id > 0) {
            try {

                if ($save == 1) {
                    $inv = R::load('manual_operation', $id);
                    $inv->kashf_exit_userid = $_SESSION['user_id'];
                    $inv->kashf_exit_time = date('Y-m-d H:i:s'); //$this->today;
                    r::store($inv);
                }


                $user = R::getRow('select  name  from awusers where user_id = ?', [$_SESSION['user_id']]);

                $result = array(
                    "date" => date('h:i A'),
                    "dateFull" => date('Y-m-d H:i:s'),
                    "userId" => $_SESSION['user_id'],
                    "userName" => $user['name']
                );

                echo json_encode($result);

//     echo 1;
            } catch (Exception $ex) {
                echo -1;
            }
        } else {
            echo -1;
        }
    }

###########################################################

    public function rfc_report() {
//check login
        autho::checkautho($this->hosturl);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $doctors = R::getAll('select awusers.user_id   , awusers.name   from     awusers     
                                                           join       awrole                                           on awusers.role_id  = awrole.id
                                                          where awusers.deleted != 1 and   awrole.is_doctor = 1');
        $this->smarty->assign('doctors', $doctors);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/rfc_report.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function rfc_report_search() {
//check login
        autho::checkautho($this->hosturl);
        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $print = filter_input(INPUT_POST, 'print');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;
        $ext = '';
        if (!empty($doctorId) && $doctorId > 0) {
//   $ext .= ' and visits.doctor_id = ' . $doctorId;
        }

        $this->rfcReportSearch($findate, $todate, $ext);
        if ($print == 1) {
//      $this->smarty->display('adddevices/rfc_report_print.html');
        } else {
            $this->smarty->display('adddevices/rfc_report_search.html');
        }
    }

    function rfcReportSearch($fromDate, $toDate, $ext) {

        $sql = 'select  count(visits.id) as rfcPatientsCount from    visits    where visits.deleted  != 1  
                  and  visits.detectionid  not in (9999  , 999 , -88) 
                and  visits.rfc  =  1    and visits.visitdate between  ? and ?    ' . $ext . '    ';
        $rfcPats = R::getRow($sql, [$fromDate, $toDate]);
        $this->smarty->assign('rfcPatientsCount', $rfcPats['rfcPatientsCount']);

        $sql = 'select  count(visits.id) as notRfcPatientsCount from    visits    where visits.deleted  != 1  
                  and  visits.detectionid  not in (9999  , 999 , -88)   
                and  (  visits.rfc  !=  1   || visits.rfc   IS NULL )     and visits.visitdate between  ? and ?    ' . $ext . '    ';
        $notRfcPats = R::getRow($sql, [$fromDate, $toDate]);
        $this->smarty->assign('notRfcPatientsCount', $notRfcPats['notRfcPatientsCount']);

        $sql = 'select  count(id) as newPatientsCount   from    patients    
                               where deleted  != 1    and entrydate between  ? and ?  
                               and  (rfc = 1 || wrfc = 1 ) ';
        $newPats = R::getRow($sql, [$fromDate, $toDate]);
        $this->smarty->assign('newPatientsCount', $newPats['newPatientsCount']);

        $this->rfcDetect($fromDate, $toDate, $ext);
    }

    function rfcDetect($fromDate, $toDate, $ext) {
        $sql = 'select   distinct (visits.patientid) as patientid   , patients.statusno   , patients.wifename
                                , patients.husdandname  ,     doctor.name  as wDrName ,     hdoctor.name  as hDrName
                                , DATE(patients.entrydate) as entryDate , 0 as newPat ,     knownfrom.name  as knownFrom
                   from    visits
                             join patients                                         on patients.id  = visits.patientid 
                              left join awusers  doctor                   on doctor.user_id = patients.doctor1  
                              left join awusers  hdoctor               on hdoctor.user_id = patients.h_doctor1  
                              left join knownfrom                         on knownfrom.id = patients.knownfrom  
                         where visits.deleted  != 1   and  visits.rfc  =  1    
                            and  visits.detectionid  not in (9999  , 999 , -88) 
                        and visits.visitdate between  ? and ?    ' . $ext . '    ';
        $rfcPatients = R::getAll($sql, [$fromDate, $toDate]);

        $x = 0;
        foreach ($rfcPatients as $rfcPatient) {
            $sql = 'select  count(visits.id) as rfcVisitsCount from    visits    where visits.deleted  != 1   
                   and  visits.detectionid  not in (9999  , 999 , -88) 
                and  visits.rfc  =  1    and visits.visitdate between  ? and ?  and visits.patientid = ?    ' . $ext . '    ';
            $rfcvisits = R::getRow($sql, [$fromDate, $toDate, $rfcPatient['patientid']]);

            $rfcPatients[$x]['rfcVisitsCount'] = $rfcvisits['rfcVisitsCount'];
            if (!($rfcPatient['entryDate'] == '0000-00-00' || is_null($rfcPatient['entryDate']) || $rfcPatient['entryDate'] == '')) {
                $rfcPatients[$x]['entryDate'] = date('Y/m/d', strtotime($rfcPatient['entryDate']));
                if ($rfcPatient['entryDate'] >= $fromDate && $rfcPatient['entryDate'] <= $toDate) {
                    $rfcPatients[$x]['newPat'] = 1;
                }
            }

            $x++;
        }
        $this->smarty->assign('rfcPatients', $rfcPatients);
    }

    public function rfcByPatient() {
//check login
        autho::checkautho($this->hosturl);
        $fromDate = filter_input(INPUT_POST, 'findate');
        $toDate = filter_input(INPUT_POST, 'todate');
        $patientName = filter_input(INPUT_POST, 'patientName');
        $patientId = (filter_input(INPUT_POST, 'patientId') > 0) ? filter_input(INPUT_POST, 'patientId') : 0;
        $ext = '';
        if (!empty($patientId) && $patientId > 0) {
            $sql = 'select  detections.title as detect  , awrole.name as department    , visits.for_husband 
                , visits.visitdate   , awusers.name as drName  , visits.notes as visitNote
                 ,   visits.recep_p_exit  ,   visits.kashf_enterance   , visits.for_department   
                  , visits.patientid    , visits.for_doctor    , visits.detectionid   
                 , DATE_FORMAT(visits.arrived_time, "%h:%i %p") as  arrivedTime 
                from    visits    
                  left  join detections    on detections.id  =  visits.detectionid 
                  left  join awrole    on awrole.id  =  visits.for_department
                  left  join awusers    on awusers.user_id  =  visits.for_doctor
                where visits.deleted  != 1   and  visits.rfc  =  1     
                and  visits.detectionid  not in (9999  , 999 , -88) 
                and visits.visitdate between  ? and ?  and visits.patientid = ?    ' . $ext . '    ';
            $patRfcvisits = R::getAll($sql, [$fromDate, $toDate, $patientId]);

            $x = 0;
            foreach ($patRfcvisits as $patRfcvisit) {
                if ($patRfcvisit['for_department'] == 13) {
                    $manual = r::getRow(' select  DATE_FORMAT(manual_operation.arrived_time, "%h:%i %p") as  arrived_time 
                                                        from manual_operation  
                                                        where  patient_id = ?  and DATE(request_date) = ?  
                                                                  and deleted != 1 and doctor_id  = ?  
                                                                 and detection_id  = ? '
                                    , [$patRfcvisit['patientid'], $patRfcvisit['visitdate'], $patRfcvisit['for_doctor'], $patRfcvisit['detectionid']]);
                    if (count($manual) > 0) {
                        $patRfcvisits[$x]['arrivedTime'] = $manual['arrived_time'];
                    }
                }
                $x++;
            }


            $this->smarty->assign('patRfcvisits', $patRfcvisits);
            $this->smarty->assign('patientName', $patientName);
            $programesetting = R::findOne('programesetting');
            $this->smarty->assign('programesetting', $programesetting);
            $this->smarty->display('adddevices/rfc_patient_visits.html');
        } else {
            echo -1;
        }
    }

    public function newPatients() {
//check login
        autho::checkautho($this->hosturl);
        $fromDate = filter_input(INPUT_POST, 'findate');
        $toDate = filter_input(INPUT_POST, 'todate');

        try {
            $sql = 'select  patients.statusno   , patients.wifename ,     knownfrom.name  as knownFrom
                                    , patients.husdandname  ,     doctor.name  as wDrName 
                                    ,  hdoctor.name  as hDrName , DATE(patients.entrydate) as entryDate 
                from    patients    
                 left join awusers  doctor                   on doctor.user_id = patients.doctor1  
                 left join awusers  hdoctor               on hdoctor.user_id = patients.h_doctor1  
                 left join knownfrom                         on knownfrom.id = patients.knownfrom  
                 where patients.deleted  != 1    and patients.entrydate between  ? and ?  
                    and  (patients.rfc = 1 || patients.wrfc = 1)   ';
            $newPats = R::getAll($sql, [$fromDate, $toDate]);


            $this->smarty->assign('newPats', $newPats);
            $programesetting = R::findOne('programesetting');
            $this->smarty->assign('programesetting', $programesetting);
            $this->smarty->display('adddevices/new_patients.html');
        } catch (Exception $ex) {
            echo -1;
        }
    }

###########################################################

    public function firstVisit() {
//check login
        autho::checkautho($this->hosturl);

        $fromDate = filter_input(INPUT_POST, 'findate');
        $toDate = filter_input(INPUT_POST, 'todate');
        $this->firstVisitSearch($fromDate, $toDate);
        $this->smarty->assign('fromDate', $fromDate);
        $this->smarty->assign('toDate', $toDate);
        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);
        $this->smarty->display('adddevices/first_visit.html');
    }

    function firstVisitSearch($fromDate, $toDate) {
        $firstVisits = array();

        $fromDate = date('Y-m-d', strtotime($fromDate));
        $toDate = date('Y-m-d', strtotime($toDate));

        $sql = 'select  distinct (visits.patientid) as patientid
                   from    visits    where visits.deleted  != 1  
                    and  visits.detectionid  not in (9999  , 999 , -88) 
                    and  visits.rfc  =  1    and visits.visitdate between  ? and ?  ';
        $rfcPats = R::getAll($sql, [$fromDate, $toDate]);

        foreach ($rfcPats as $rfcPat) {
            $sql = 'select  visits.id ,   visits.visitdate  ,   visits.call_date  ,   visits.attend_deley ,   visits.customer_add
                                  , patients.wifename  , patients.husdandname   , patients.phone  
                                  , DATE(patients.entrydate) as entryDate
                                  ,  knownfrom.name  as knownFrom ,  awusers.name  as visitDrName   
                   from    visits    
                       join patients                                         on patients.id  = visits.patientid 
                        left join knownfrom                         on knownfrom.id = patients.knownfrom  
                         left join awusers                          on awusers.user_id = visits.for_doctor  
                   where visits.deleted  != 1  
                    and  visits.detectionid  not in (9999  , 999 , -88) 
                    and  visits.rfc  =  1   and   visits.patientid =  ?  
                    order by  visits.visitdate asc   ';
            $visit = R::getRow($sql, [$rfcPat['patientid']]);

            if ($visit['visitdate'] <= $toDate && $visit['visitdate'] >= $fromDate) {
                array_push($firstVisits, $visit);
            }
        }
        $this->smarty->assign('firstVisits', $firstVisits);
    }

###########################################################

    public function address_report() {
//check login
        autho::checkautho($this->hosturl);

        $governorates = R::findAll('governorate', ' deleted = 0 order by name');
        $this->smarty->assign('governorates', $governorates);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/address_report.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function address_report_search() {
//check login
        autho::checkautho($this->hosturl);
        $print = filter_input(INPUT_POST, 'print');
        $governorate = (filter_input(INPUT_POST, 'governorate') > 0) ? filter_input(INPUT_POST, 'governorate') : 0;
        $center = (filter_input(INPUT_POST, 'center') > 0) ? filter_input(INPUT_POST, 'center') : 0;
        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $ext = '';
        if (!empty($governorate) && $governorate > 0) {
            $ext .= ' and patients.governorate = ' . $governorate;
        }

        if (!empty($center) && $center > 0) {
            $ext .= ' and patients.governorate_center = ' . $center;
        }

        $this->addressReportSearch($findate, $todate, $ext);
        if ($print == 1) {
//      $this->smarty->display('adddevices/rfc_report_print.html');
        } else {
            $this->smarty->display('adddevices/address_report_search.html');
        }
    }

    function addressReportSearch($fromDate, $toDate, $ext) {
        $sql = 'select  distinct  patients.governorate as governorateId    ,  governorate.name as governorateName     
                        , 0 as patientsCount  
                    from    patients    
                      join   governorate                                       on   patients.governorate   =  governorate.id     
                    where patients.deleted  != 1     and  patients.done  =  1 
                     and DATE(patients.entrydate) between  ? and ?    ' . $ext . '     ';

        $governorates = R::getAll($sql, [$fromDate, $toDate]);
        $this->centersByGovId($governorates, $fromDate, $toDate, $ext);
    }

    function centersByGovId($governorates, $fromDate, $toDate, $ext) {
        $totalResult = 0;
        $i = 0;
        foreach ($governorates as $governorate) {
            $sql = 'select  distinct  patients.governorate_center as centerId  ,  governorate_centers.name as centerName 
                    from    patients    
                    left  join   governorate_centers                          on   patients.governorate_center   =  governorate_centers.id     
                    where patients.deleted  != 1     and  patients.done  =  1 
                       and  patients.governorate  =  ' . $governorate['governorateId'] . '        
                     and DATE(patients.entrydate) between  ? and ?    ' . $ext . '     ';


            $centers = R::getAll($sql, [$fromDate, $toDate]);
            $j = 0;
            foreach ($centers as $center) {
                $sql = 'select  distinct patients.id  
                    from    patients    
                    left join   governorate_centers                          on   patients.governorate_center   =  governorate_centers.id
                       join   governorate                                       on   patients.governorate   =  governorate.id     
                   where patients.deleted  != 1     and  patients.done  =  1  
                      and  patients.governorate_center  =  ' . $center['centerId'] . '    and  patients.governorate  =  ' . $governorate['governorateId'] . '              
                     and DATE(patients.entrydate) between  ? and ?    ' . $ext . '      ';

                $patients = R::getAll($sql, [$fromDate, $toDate]);

                $centers[$j]['patientsCount'] = count($patients);
                $governorates[$i]['patientsCount'] = $governorates[$i]['patientsCount'] + count($patients);
                $totalResult = $totalResult + count($patients);
                $j++;
            }
            $governorates[$i]['centers'] = $centers;
            $governorates[$i]['centersCount'] = count($centers);
            $i++;
        }

        $this->smarty->assign('governorates', $governorates);
        $this->smarty->assign('totalResult', $totalResult);
    }

    function addressSearchDetail() {
        autho::checkautho($this->hosturl);
        $centerId = (filter_input(INPUT_POST, 'center') > 0) ? filter_input(INPUT_POST, 'center') : 0;
        $govId = (filter_input(INPUT_POST, 'govId') > 0) ? filter_input(INPUT_POST, 'govId') : 0;
        $fromDate = filter_input(INPUT_POST, 'findate');
        $toDate = filter_input(INPUT_POST, 'todate');

        if ($govId > 0) {
            $gov = R::load('governorate', $govId);
            $this->smarty->assign('govName', $gov->name);
        }

        $this->smarty->assign('centerId', $centerId);
        if ($centerId > 0) {
            $center = R::load('governorate_centers', $centerId);
            $this->smarty->assign('centerName', $center->name);
        }
        $patients = $this->centersPatients($govId, $centerId, $fromDate, $toDate);
        $this->smarty->assign('patients', $patients);
        $this->smarty->display('adddevices/address_modal.html');
    }

    function centersPatients($govId, $centerId, $fromDate, $toDate) {
        $sql = 'select  distinct (patients.id) as patientId  , patients.statusno   , patients.wifename
                                , patients.husdandname   , patients.address   , DATE(patients.entrydate) as entryDate
                    from    patients    
                       join   governorate                                       on   patients.governorate   =  governorate.id     
                   where patients.deleted  != 1     and  patients.done  =  1  
                      and  patients.governorate_center  =  ' . $centerId . '    and  patients.governorate  =  ' . $govId . '         
                     and DATE(patients.entrydate) between  ? and ?    ';

        $patients = R::getAll($sql, [$fromDate, $toDate]);
        return $patients;
    }

    ###########################################################

    public function nationality_report() {
//check login
        autho::checkautho($this->hosturl);

        $nationality = R::findAll('nationality', 'deleted = 0 order by name');
        $this->smarty->assign('nationality', $nationality);

        $hnationality = R::findAll('hnationality', 'deleted = 0 order by name');
        $this->smarty->assign('hnationality', $hnationality);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('adddevices/nationality_report.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function nationality_report_search() {
//check login
        autho::checkautho($this->hosturl);
        $print = filter_input(INPUT_POST, 'print');
        $hNationalityId = (filter_input(INPUT_POST, 'hNationality') > 0) ? filter_input(INPUT_POST, 'hNationality') : 0;
        $nationalityId = (filter_input(INPUT_POST, 'nationality') > 0) ? filter_input(INPUT_POST, 'nationality') : 0;
        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');

        $this->nationalityReportSearch($findate, $todate, $nationalityId, $hNationalityId);
        $this->smarty->assign('nationalityId', $nationalityId);
        $this->smarty->assign('hNationalityId', $hNationalityId);
        if ($print == 1) {
//      $this->smarty->display('adddevices/rfc_report_print.html');
        } else {
            $this->smarty->display('adddevices/nationality_report_search.html');
        }
    }

    function nationalityReportSearch($fromDate, $toDate, $nationalityId, $hNationalityId) {

        if (!empty($nationalityId) && $nationalityId > 0 && !empty($hNationalityId) && $hNationalityId > 0) {
            $natTxt = $nationalityId . '-' . $hNationalityId;
            $sql = "SELECT CONCAT(patients.nationality , '-', patients.h_nationality) AS nationalityConcat
                 , patients.nationality as nationalityId  ,  nationality.name as nationalityName    
                ,  patients.h_nationality as h_nationalityId  ,  hnationality.name as hnationalityName  
                 from    patients    
                   join   nationality                          on   patients.nationality   =  nationality.id     
                     join   hnationality                          on   patients.h_nationality   =  hnationality.id   
                WHERE  patients.deleted  != 1     and  patients.done  =  1  and DATE(patients.entrydate) between  ? and ?
               and  CONCAT(patients.nationality , '-', patients.h_nationality) = '" . $natTxt . "' 
                 group by CONCAT(patients.nationality , '-', patients.h_nationality);";
        } else {
            if (!empty($nationalityId) && $nationalityId > 0) {
                $sql = 'select  distinct  patients.nationality as nationalityId  ,  nationality.name as nationalityName     
                   ,  patients.h_nationality as h_nationalityId  ,  hnationality.name as hnationalityName  
                    from    patients    
                      join   nationality                          on   patients.nationality   =  nationality.id     
                     left     join   hnationality                          on   patients.h_nationality   =  hnationality.id   
                    where patients.deleted  != 1     and  patients.done  =  1  
                     and DATE(patients.entrydate) between  ? and ?    and patients.nationality = ' . $nationalityId . '     ';
            } elseif (!empty($hNationalityId) && $hNationalityId > 0) {
                $sql = 'select  distinct  patients.h_nationality as h_nationalityId  ,  hnationality.name as hnationalityName    
                    , patients.nationality as nationalityId  ,  nationality.name as nationalityName     
                    from    patients    
                     join   hnationality                          on   patients.h_nationality   =  hnationality.id  
                       left     join   nationality                          on   patients.nationality   =  nationality.id     
                    where patients.deleted  != 1     and  patients.done  =  1  
                     and DATE(patients.entrydate) between  ? and ?    and patients.h_nationality = ' . $hNationalityId . '     ';
            } else {
                $sql = "SELECT CONCAT(patients.nationality , '-', patients.h_nationality) AS nationalityConcat
                     , patients.nationality as nationalityId  ,  nationality.name as nationalityName    
                ,  patients.h_nationality as h_nationalityId  ,  hnationality.name as hnationalityName  
                 from    patients    
                 left   join   nationality                          on   patients.nationality   =  nationality.id     
                  left    join   hnationality                          on   patients.h_nationality   =  hnationality.id   
                WHERE  patients.deleted  != 1     and  patients.done  =  1   and DATE(patients.entrydate) between  ? and ?
                 group by CONCAT(patients.nationality , '-', patients.h_nationality);";
            }
        }

        $nationalities = R::getAll($sql, [$fromDate, $toDate]);

        $this->nationalityCommon($nationalities, $fromDate, $toDate);
    }

    function nationalityCommon($nationalities, $fromDate, $toDate) {
        $totalResult = 0;
        $i = 0;
        foreach ($nationalities as $nat) {
            $patients = $this->nationalityPatients($nat['nationalityId'], $nat['h_nationalityId'], $fromDate, $toDate);
            $nationalities[$i]['patientsCount'] = count($patients);
            $totalResult = $totalResult + count($patients);
            $i++;
        }
        $this->smarty->assign('nationalities', $nationalities);
        $this->smarty->assign('totalResult', $totalResult);
    }

    function nationalitySearchDetail() {
        autho::checkautho($this->hosturl);
        $nationalityId = (filter_input(INPUT_POST, 'nationalityId') > 0) ? filter_input(INPUT_POST, 'nationalityId') : 0;
        $h_nationalityId = (filter_input(INPUT_POST, 'h_nationalityId') > 0) ? filter_input(INPUT_POST, 'h_nationalityId') : 0;
        $fromDate = filter_input(INPUT_POST, 'findate');
        $toDate = filter_input(INPUT_POST, 'todate');

        $this->smarty->assign('nationalityId', $nationalityId);
        if ($nationalityId > 0) {
            $nationality = R::load('nationality', $nationalityId);
            $this->smarty->assign('natName', $nationality->name);
        }

        $this->smarty->assign('h_nationalityId', $h_nationalityId);
        if ($h_nationalityId > 0) {
            $hnationality = R::load('hnationality', $h_nationalityId);
            $this->smarty->assign('hNatName', $hnationality->name);
        }

        $patients = $this->nationalityPatients($nationalityId, $h_nationalityId, $fromDate, $toDate);
        $this->smarty->assign('patients', $patients);
        $this->smarty->display('adddevices/nationality_modal.html');
    }

    function nationalityPatients($nationalityId, $h_nationalityId, $fromDate, $toDate) {
        $sql = 'select  distinct (patients.id) as patientId  , patients.statusno   , patients.wifename
                                , patients.husdandname   , patients.address   , DATE(patients.entrydate) as entryDate
                    from    patients     ';

        $sqlWhere = ' where patients.deleted  != 1     and  patients.done  =  1   
                    and DATE(patients.entrydate) between  ? and ?     ';

        if (!empty($nationalityId) && $nationalityId > 0 && !empty($h_nationalityId) && $h_nationalityId > 0) {
            $sqlJoin = '   join   nationality                          on   patients.nationality   =  nationality.id     
                     join   hnationality                          on   patients.h_nationality   =  hnationality.id   ';

            $sqlWhere .= '  and  patients.nationality  =  ' . $nationalityId . '        ';
            $sqlWhere .= '  and  patients.h_nationality  =  ' . $h_nationalityId . '        ';
        } else {
            if (!empty($nationalityId) && $nationalityId > 0) {
                $sqlJoin = '   join   nationality                          on   patients.nationality   =  nationality.id     
                    left   join   hnationality                          on   patients.h_nationality   =  hnationality.id   ';

                $sqlWhere .= '  and  patients.nationality  =  ' . $nationalityId . '        ';
            } elseif (!empty($h_nationalityId) && $h_nationalityId > 0) {
                $sqlJoin = ' left   join   nationality                          on   patients.nationality   =  nationality.id     
                       join   hnationality                          on   patients.h_nationality   =  hnationality.id   ';


                $sqlWhere .= '  and  patients.h_nationality  =  ' . $h_nationalityId . '        ';
            } else {
                $sqlJoin = ' left   join   nationality                          on   patients.nationality   =  nationality.id     
                       left  join   hnationality                          on   patients.h_nationality   =  hnationality.id   ';

                $sqlWhere .= '  and  ( patients.nationality  is null  || patients.nationality  = "" )      ';
                $sqlWhere .= '  and  ( patients.h_nationality    is null  || patients.h_nationality  = "" )          ';
            }
        }

        $sql .= $sqlJoin . ' ' . $sqlWhere;

        $patients = R::getAll($sql, [$fromDate, $toDate]);
        return $patients;
    }

    ###########################################################

    private function getDayNameFnAr($date) {
        $timestamp = strtotime($date);

        $day = date('w', $timestamp);

        switch ($day) {
            case 0:
                $name = 'الأحد  ';
                break;
            case 1:
                $name = ' الإثنين';
                break;
            case 2:
                $name = ' الثلاثاء';
                break;
            case 3:
                $name = 'الأربعاء ';
                break;
            case 4:
                $name = 'الخميس  ';
                break;
            case 5:
                $name = 'الجمعة ';
                break;
            case 6:
                $name = 'السبت ';
                break;
        }

        return $name;
    }

// at the end of class call
    public function __destruct() {
//echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }

}
