<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'center_reports';
        $this->shcontrollname = 'center_reports';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'programesetting'; //controller name or tab name
        $active[1] = 'reports'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });


//here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    ######################### temporary cases report ##############################

    public function temporary() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #################################################################### 

        $this->smarty->assign('today', date('Y/m/d', strtotime(date("Y/m/d"))));
        $this->smarty->assign('reportAc', 'temporary');
        $this->smarty->assign('reportName', 'Temporary Cases');

        ####################################################################
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('center_reports/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function temporarySearch() {
        //check login
        autho::checkautho($this->hosturl);
        ##############################################################################

        $fromDate = filter_input(INPUT_POST, 'fromDate');
        $toDate = filter_input(INPUT_POST, 'toDate');

        ##############################################################################

        $sql = 'select  patients.id as  patient_id  , patients.wifename   , patients.husdandname      , patients.statusno
                                        , DATE(patients.entrydate) AS entrydate
                                       from    patients
                         where DATE(patients.entrydate) between ? and ?     and  DATE(patients.entrydate)  >= "2022-04-01"  
                          and  ( patients.wifenationalid  IS   Null   ||  patients.wifenationalid  = ""   )
                        ';

        $patients = R::getAll($sql, [$fromDate, $toDate]);

        $i = 0;
        foreach ($patients as $patient) {
            $sql = 'select  visitdate    from    visits     where patientid = ? order  by visitdate desc   ';
            $visit = R::getRow($sql, [$patient['patient_id']]);
            $patients[$i]['lastvisitdate'] = $visit['visitdate'];
            $i++;
        }


        $this->smarty->assign('patients', $patients);

        $this->smarty->display('center_reports/temporary_search.html');
    }

    ######################### center  known report ##############################

    public function known() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #################################################################### 

        $knownfrom = R::findAll('knownfrom', 'deleted = 0 order by name');
        $this->smarty->assign('knownfrom', $knownfrom);

        $this->smarty->assign('today', date('Y/m/d', strtotime(date("Y/m/d"))));
        $this->smarty->assign('reportAc', 'known');
        $this->smarty->assign('reportPrint', 1);
        $this->smarty->assign('reportName', " Center's Knowledge ");

        ####################################################################
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('center_reports/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function knownSearch() {
        //check login
        autho::checkautho($this->hosturl);
        ##############################################################################
        $this->knownCommon();

        $this->smarty->display('center_reports/known_search.html');
    }

    public function knownPrint() {
        //check login
        autho::checkautho($this->hosturl);
        ##############################################################################

        $this->knownCommon();

        $this->smarty->display('center_reports/known_print.html');
    }

    public function knownCommon() {
        //check login
        autho::checkautho($this->hosturl);
        ##############################################################################

        $fromDate = filter_input(INPUT_POST, 'fromDate');
        $toDate = filter_input(INPUT_POST, 'toDate');
        $knownFrom = filter_input(INPUT_POST, 'knownFrom');

        ##############################################################################
        $ext = '';
        if ($knownFrom > 0) {
            $ext .= ' and id = ' . $knownFrom;
        }
        $sql = 'select  knownfrom.id as  knownFromId  , knownfrom.name  
                                       from    knownfrom   where deleted = 0  ' . $ext . '   order by name';

        $knownfroms = R::getAll($sql);

        $i = 0;
        foreach ($knownfroms as $knownfrom) {
            $sql = 'select  count(id) as patCount    from    patients    
                    where DATE(entrydate) between ? and ? and  knownfrom = ?  ';
            $pats = R::getRow($sql, [$fromDate, $toDate, $knownfrom['knownFromId']]);
            $knownfroms[$i]['patCount'] = $pats['patCount'];
            $i++;
        }

        $this->smarty->assign('fromDate', $fromDate);
        $this->smarty->assign('toDate', $toDate);
        $this->smarty->assign('knownfroms', $knownfroms);
    }

    public function knownFromDetails() {
        //check login
        autho::checkautho($this->hosturl);
        ##############################################################################

        $fromDate = filter_input(INPUT_POST, 'fromDate');
        $toDate = filter_input(INPUT_POST, 'toDate');
        $knownFromId = filter_input(INPUT_POST, 'knownFromId');

        ##############################################################################

        if ($knownFromId > 0) {
            $knownfrom = R::load('knownfrom', $knownFromId);
            $this->smarty->assign('knownfromName', $knownfrom->name);

            $sql = 'select   patients.id as  patient_id  , patients.wifename   , patients.husdandname      , patients.statusno 
                         , patients.address   , patients.phone   , patients.mobile
                        from    patients    
                    where DATE(entrydate) between ? and ? and  knownfrom = ?  ';

            $patients = R ::getAll($sql, [$fromDate, $toDate, $knownFromId]);
            $this->smarty->assign('patients', $patients);
            $this->smarty->display('center_reports/known_search_patients.html');
        }
    }

    #######################################################

    public function update() {
        $id = filter_input(INPUT_POST, "id");
        $value = filter_input(INPUT_POST, "value");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");

        //here the update
        $mydata = R:: load($tableName, $id);

        $mydata->$colName = $value;
        R::store($mydata);
    }

// at the end of class call
    public function __destruct() {
        //echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }

}
