<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'instruction';
        $this->shcontrollname = 'instruction';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'instruction'; //controller name or tab name
        $active[1] = 'instruction'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'instructionadd';
                break;
            case 'show':$active[2] = 'instructionshow';
                break;
            default :$active[2] = 'instructionshow';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });


//here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('instruction/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $content = filter_input(INPUT_POST, 'content');

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);

        //here the add
        $instruction = R::dispense('instruction');

        $instruction->name = $name;
        $instruction->content = $content;
        $instruction->patientid = 1;


        try {
            $id = R::store($instruction);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
        //load all parents here
        $showElems = R::getAll('SELECT * FROM instruction WHERE tempdelete = 0');
        $this->smarty->assign('showElems', $showElems);

        $this->smarty->assign('patientId', $patientid);

        $this->smarty->assign('date', $this->today);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('instruction/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");

        //load all here
        $editElement = R::load('instruction', $id);
        $this->smarty->assign('editElement', $editElement);
        $this->smarty->assign('patientId', $patientid);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('instruction/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $content = filter_input(INPUT_POST, 'content');

        $id = filter_input(INPUT_POST, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);


        //here the update
        $instruction = R::load('instruction', $id);

        $instruction->name = $name;
        $instruction->content = $content;
        $instruction->patientid = 1;



        try {
            R::store($instruction);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            R::exec('UPDATE instruction SET tempdelete = 1 WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            
        }
    }

    public function getprint() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $instructionArray = json_decode(stripslashes(filter_input(INPUT_POST, 'jsonString')));


        $instructionArrayNew = array();

        $patientId = filter_input(INPUT_POST, "patientId");
        $printDate = filter_input(INPUT_POST, "printDate");

        foreach ($instructionArray as $inst) {
            $instruction = R::load('instruction', $inst);
            array_push($instructionArrayNew, $instruction);
        }


        if (!empty($patientId)) {
            $patient = R::load('patients', $patientId);

            if ($_SESSION['role_id'] == 12) {

                $this->smarty->assign('statusNo', $patient->statusno);
                $this->createbarcode($patient->statusno);

                $this->smarty->assign('dateTime', date("Y/m/d h:i A"));

                $wifetypes = R::load('wifetypes', $patient->wiftypeid);
                $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);

                if ($visit->for_husband != 1) {
                    $this->smarty->assign('name', $patient->wifename);
                    $this->smarty->assign('title', $wifetypes->title);
                    $this->smarty->assign('sex', 'Female');

                    if (!empty($patient->refer_doctor)) {
                        $doc_info = R::getRow('select * from awusers where user_id = ?', [$patient->refer_doctor]);
                        $this->smarty->assign('doctor_name', $doc_info['name']);
                    } else {
                        $this->smarty->assign('doctor_name', '');
                    }

                    if ($patient->dateofbirth == '0000-00-00' || is_null($patient->dateofbirth)) {
                        $this->smarty->assign('age', 0);
                    } else {
                        ## calculate wife age
                        $dateWife = new DateTime($patient->dateofbirth);
                        $today1 = new DateTime(date('Y-m-d'));
                        $interva2 = $today1->diff($dateWife);
                        $this->smarty->assign('age', $interva2->y);
                    }
                } else {
                    $this->smarty->assign('name', $patient->husdandname);
                    $this->smarty->assign('title', $husbandtypes->title);
                    $this->smarty->assign('sex', 'Male');

                    if (!empty($patient->h_refer_doctor)) {
                        $doc_info = R::getRow('select * from awusers where user_id = ?', [$patient->h_refer_doctor]);
                        $this->smarty->assign('doctor_name', $doc_info['name']);
                    } else {
                        $this->smarty->assign('doctor_name', '');
                    }


                    if ($patient->husbanddateofbirth == '0000-00-00' || is_null($patient->husbanddateofbirth)) {
                        $this->smarty->assign('age', 0);
                    } else {
                        ## calculate husband age
                        $dateHusband = new DateTime($patient->husbanddateofbirth);
                        $today1 = new DateTime(date('Y-m-d'));
                        $interval = $today1->diff($dateHusband);
                        $this->smarty->assign('age', $interval->y);
                    }
                }

                $programesetting = R::findOne('programesetting');
                $this->smarty->assign('programesetting', $programesetting);




                $this->smarty->display('instruction/print_lab.html');
            } else {

                $this->smarty->assign('patient', $patient);

                //  $this->createbarcode($patient->statusno);

                $doc = R::findOne('awusers', 'user_id = ?', [$patient->doctor1]);
                $h_doc = R::findOne('awusers', 'user_id = ?', [$patient->h_doctor1]);

                $this->smarty->assign('doctor_name', $doc->name);
                $this->smarty->assign('h_doctor_name', $h_doc->name);


                $visit = R::findOne('visits', 'patientid = ? and deleted  != 1  order by visitdate desc , id desc '
                                , [$patientId]);


                $user = R::findOne('awusers', 'user_id = ?', [$visit->user_id]);

                $this->smarty->assign('user_name', $user->name);
                $this->smarty->assign('printserial', $visit->printserial);


                $this->smarty->display('instruction/print.html');
            }



            ################################
        } else {
            $patientId = 0;
        }



        $this->smarty->assign('patientId', $patientId);
        $this->smarty->assign('printDate', $printDate);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $this->smarty->assign('instructions', $instructionArrayNew);
        $this->smarty->assign('show', 0);

        if ($_SESSION['role_id'] == 12) {
            $this->smarty->display('instruction/print_lab.html');
        } else {
            $this->smarty->display('instruction/print.html');
        }
    }

    public function getinstdetail() {

        //check login
        autho::checkautho($this->hosturl);
//        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $instructionId = filter_input(INPUT_POST, "instructionId");
        $instruction = R::load('instruction', $instructionId);
        $patientId = filter_input(INPUT_POST, "patientId");
        $printDate = filter_input(INPUT_POST, "printDate");


        if (!empty($patientId)) {
            $patient = R::load('patients', $patientId);

            if ($_SESSION['role_id'] == 12) {

                $this->smarty->assign('statusNo', $patient->statusno);
                $this->createbarcode($patient->statusno);

                $this->smarty->assign('dateTime', date("Y/m/d h:i A"));

                $wifetypes = R::load('wifetypes', $patient->wiftypeid);
                $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);

                if ($visit->for_husband != 1) {
                    $this->smarty->assign('name', $patient->wifename);
                    $this->smarty->assign('title', $wifetypes->title);
                    $this->smarty->assign('sex', 'Female');

                    if (!empty($patient->refer_doctor)) {
                        $doc_info = R::getRow('select * from awusers where user_id = ?', [$patient->refer_doctor]);
                        $this->smarty->assign('doctor_name', $doc_info['name']);
                    } else {
                        $this->smarty->assign('doctor_name', '');
                    }


                    if ($patient->dateofbirth == '0000-00-00' || is_null($patient->dateofbirth)) {
                        $this->smarty->assign('age', 0);
                    } else {
                        ## calculate wife age
                        $dateWife = new DateTime($patient->dateofbirth);
                        $today1 = new DateTime(date('Y-m-d'));
                        $interva2 = $today1->diff($dateWife);
                        $this->smarty->assign('age', $interva2->y);
                    }
                } else {
                    $this->smarty->assign('name', $patient->husdandname);
                    $this->smarty->assign('title', $husbandtypes->title);
                    $this->smarty->assign('sex', 'Male');

                    if (!empty($patient->h_refer_doctor)) {
                        $doc_info = R::getRow('select * from awusers where user_id = ?', [$patient->h_refer_doctor]);
                        $this->smarty->assign('doctor_name', $doc_info['name']);
                    } else {
                        $this->smarty->assign('doctor_name', '');
                    }


                    if ($patient->husbanddateofbirth == '0000-00-00' || is_null($patient->husbanddateofbirth)) {
                        $this->smarty->assign('age', 0);
                    } else {
                        ## calculate husband age
                        $dateHusband = new DateTime($patient->husbanddateofbirth);
                        $today1 = new DateTime(date('Y-m-d'));
                        $interval = $today1->diff($dateHusband);
                        $this->smarty->assign('age', $interval->y);
                    }
                }

                $programesetting = R::findOne('programesetting');
                $this->smarty->assign('programesetting', $programesetting);



                $this->smarty->display('instruction/print_lab.html');
            } else {

                $this->smarty->assign('patient', $patient);

                //  $this->createbarcode($patient->statusno);

                $doc = R::findOne('awusers', 'user_id = ?', [$patient->doctor1]);
                $h_doc = R::findOne('awusers', 'user_id = ?', [$patient->h_doctor1]);

                $this->smarty->assign('doctor_name', $doc->name);
                $this->smarty->assign('h_doctor_name', $h_doc->name);


                $visit = R::findOne('visits', 'patientid = ? and deleted  != 1  order by visitdate desc , id desc '
                                , [$patientId]);


                $user = R::findOne('awusers', 'user_id = ?', [$visit->user_id]);

                $this->smarty->assign('user_name', $user->name);
                $this->smarty->assign('printserial', $visit->printserial);
            }
            ################################
        } else {
            $patientId = 0;
        }

        $this->smarty->assign('printDate', $printDate);

        $this->smarty->assign('patientId', $patientId);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $this->smarty->assign('instructions', $instruction);
        $this->smarty->assign('show', 1);

        if ($_SESSION['role_id'] == 12) {
            $this->smarty->display('instruction/print_lab.html');
        } else {
            $this->smarty->display('instruction/print.html');
        }
    }

    public function createbarcode($statusno) {
        if (file_exists('../../upload/barcodes/' . $statusno . '.png')) {
            
        } else {
            $url = $this->hosturl . '/../_library/barcode/image.php?code=' . $statusno . '&width=300&height=60&type=C39';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $barcode = curl_exec($ch);

            if ($barcode === false) {
                $curl_result = curl_error($ch);
            } else {
                // header( 'Content-Type: application/json' );
                ## save the file to disk 
                file_put_contents('../../upload/barcodes/' . $statusno . '.png', $barcode);
            }
            curl_close($ch);
        }
    }

    public function showtransfer() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }


        $myallobsteric = R::getAll('select id  from phobstetric where del = ?  and patientid = ? ', [0, $patientid]);
        $getAllPatientData = R::getRow("SELECT * FROM patients WHERE id = $patientid");
        $p = $getAllPatientData['pno'];
        $ab = $getAllPatientData['ab'];
        $Ectopic = $getAllPatientData['ectopic'];
        $vmodel = $getAllPatientData['vmodel'];

        $obstriccountnew = count($myallobsteric) + $p + $ab + $Ectopic + $vmodel;
        $mainObj = R::findOne('mainantenental', 'done = 0 AND patientid = ?', [$patientid]); ##  done = 0 current pregnancy
        $mainObj->g = $obstriccountnew + 1;

        $svddata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [1, $patientid]);
        $csdata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [2, $patientid]);
        $pcounter = count($svddata) + count($csdata) + $p;

        if (!empty($mainObj->eed) && $mainObj->eed != "0000-00-00") {
            $mainObj->eed = date("d-m-Y", strtotime($mainObj->eed));
        } elseif ($mainObj->eed == "0000-00-00") {
            $mainObj->eed = '';
        }

        $blodd = R::load('bloodtypes', $getAllPatientData['wifebl']);

        $this->smarty->assign('patientData', $getAllPatientData);
        $this->smarty->assign('mainObj', $mainObj);
        $this->smarty->assign('p', $pcounter);
        $this->smarty->assign('blodd', $blodd->title);


        $date1 = new DateTime(date('Y-m-d'));
        $date2 = new DateTime($mainObj->lmp);
        $interval = $date1->diff($date2);

        $this->smarty->assign('weeks', round($interval->days / 7));

        $antUS = R::getRow('select placenta from mainantenentalus where deleted = ? and patientid = ? and mainantenatalid = ?  ORDER BY date DESC limit 1 ', [0, $patientid, $mainObj->id]);
        $this->smarty->assign('antUS', $antUS);

######################################################################################################################################################
        ## medical Diseases
        $mypastmedical = R::findall('phpastmedical', 'del = ? and patientid = ? ', [0, $patientid]);
        $allD = '';
        foreach ($mypastmedical as $myallpastmedical) {
            $disease = R::getRow('select name from phpastmedicaldisease where id = ?', [$myallpastmedical->medicaldisease]);
            if ($disease['name'] && $disease['name'] != '') {
                if ($allD != '') {
                    $allD .= ' , ';
                    $allD .= $disease['name'];
                } else {
                    $allD .= $disease['name'];
                }
            }
        }
        $this->smarty->assign('mypastmedical', $allD);

#####################################################################################################################################################
        ## hospitals
        $hospitalnames = R::findall('hospitalnames');
        $this->smarty->assign('hospitalnames', $hospitalnames);

#############################################################################################################################################
        ## call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }

#############################################################################################################################################
        $instructions = R::findall('operationinstructions', 'deleted = 0');
        $this->smarty->assign('instructions', $instructions);


        $this->smarty->display('instruction/transfer.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function printtransfer() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $hospitalId = filter_input(INPUT_POST, "hospitalName");
        $opInst = filter_input(INPUT_POST, "value");
        $instNotes = filter_input(INPUT_POST, "instNotes");
        $patientId = filter_input(INPUT_POST, "patientId");


        $myallobsteric = R::getAll('select id  from phobstetric where del = ?  and patientid = ? ', [0, $patientId]);
        $getAllPatientData = R::getRow("SELECT * FROM patients WHERE id = $patientId");
        $p = $getAllPatientData['pno'];
        $ab = $getAllPatientData['ab'];
        $Ectopic = $getAllPatientData['ectopic'];
        $vmodel = $getAllPatientData['vmodel'];

        $obstriccountnew = count($myallobsteric) + $p + $ab + $Ectopic + $vmodel;
        $mainObj = R::findOne('mainantenental', 'done = 0 AND patientid = ?', [$patientId]); ##  done = 0 current pregnancy
        $mainObj->g = $obstriccountnew + 1;

        $svddata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [1, $patientId]);
        $csdata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [2, $patientId]);
        $pcounter = count($svddata) + count($csdata) + $p;

        if (!empty($mainObj->eed) && $mainObj->eed != "0000-00-00") {
            $mainObj->eed = date("Y/m/d", strtotime($mainObj->eed));
        } elseif ($mainObj->eed == "0000-00-00") {
            $mainObj->eed = '';
        }

        $blodd = R::load('bloodtypes', $getAllPatientData['wifebl']);

        $this->smarty->assign('patientData', $getAllPatientData);
        $this->smarty->assign('mainObj', $mainObj);
        $this->smarty->assign('p', $pcounter);
        $this->smarty->assign('blodd', $blodd->title);


        $date1 = new DateTime(date('Y-m-d'));
        $date2 = new DateTime($mainObj->lmp);
        $interval = $date1->diff($date2);


        $getHospital = R::getRow("SELECT name FROM hospitalnames WHERE id = ?", [$hospitalId]);
        $hospitalName = $getHospital['name'];
        $allOp = json_decode($opInst);

        $allOpInst = Array();
        foreach ($allOp as $op) {
            $opTxt = R::load('operationinstructions', $op);
            array_push($allOpInst, $opTxt);
        }
        $wifetypes = R::load('wifetypes', $getAllPatientData['wiftypeid']);
        $this->smarty->assign('name', $getAllPatientData['wifename']);
        $this->smarty->assign('title', $wifetypes->title);
        $this->smarty->assign('statusNo', $getAllPatientData['statusno']);

        $this->smarty->assign('patientData', $getAllPatientData);
        $this->smarty->assign('mainObj', $mainObj);
        $this->smarty->assign('p', $pcounter);
        $this->smarty->assign('blodd', $blodd->title);
        $this->smarty->assign('weeks', round($interval->days / 7));
        $this->smarty->assign('hospitalName', $hospitalName);

        $this->smarty->assign('opInst', $allOpInst);
        $this->smarty->assign('instNotes', $instNotes);
        $this->smarty->assign('patientId', $patientId);

        $date = date("Y/m/d");
        $this->smarty->assign('date', $date);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $antUS = R::getRow('select placenta from mainantenentalus where deleted = ? and patientid = ? and mainantenatalid = ?  ORDER BY date DESC limit 1 ', [0, $patientId, $mainObj->id]);
        $this->smarty->assign('antUS', $antUS);



######################################################################################################################################################
        ## medical Diseases
        $mypastmedical = R::findall('phpastmedical', 'del = ? and patientid = ? ', [0, $patientId]);
        $allD = '';
        foreach ($mypastmedical as $myallpastmedical) {
            $disease = R::getRow('select name from phpastmedicaldisease where id = ?', [$myallpastmedical->medicaldisease]);
            if ($disease['name'] && $disease['name'] != '') {
                if ($allD != '') {
                    $allD .= ' , ';
                    $allD .= $disease['name'];
                } else {
                    $allD .= $disease['name'];
                }
            }
        }
        $this->smarty->assign('mypastmedical', $allD);

        ######################################################################################################################################################
        ## medical Diseases
        $mypastsurgical = R::findall('phpastsurgical', 'del = ? and patientid = ? ', [0, $patientId]);
        $allS = '';
        foreach ($mypastsurgical as $pastSurgical) {
            $operation = R::getRow('select name from phpastsurgicaloperation where id = ?', [$pastSurgical->surgicaloperation]);
            if ($operation['name'] && $operation['name'] != '') {
                if ($allS != '') {
                    $allS .= ' , ';
                    $allS .= $operation['name'];
                } else {
                    $allS .= $operation['name'];
                }
            }
        }
        $this->smarty->assign('mypastsurgical', $allS);

        ######################################################################################################################################################
        ## medical Diseases
        $mypastgyna = R::findall('phpastgynecological', 'del = ? and patientid = ? ', [0, $patientId]);
        $allG = '';
        foreach ($mypastgyna as $gynacological) {
            $opG = R::getRow('select name from phpastgynecologicaloperation where id = ?', [$gynacological->gynecologicaloperation]);
            if ($opG['name'] && $opG['name'] != '') {
                if ($allG != '') {
                    $allG .= ' , ';
                    $allG .= $opG['name'];
                } else {
                    $allG .= $opG['name'];
                }
            }
        }
        $this->smarty->assign('mypastgyna', $allG);

#############################################################################################################################################



        $this->smarty->display('instruction/printtransfer.html');
    }

    public function addnewhospital() {


        //vars here
        $name = filter_input(INPUT_POST, 'selectedhospital');

        ### insert into table
        $newtable = R::dispense('hospitalnames');
        $newtable->name = $name;

        $insertid = R::store($newtable);

        echo $insertid;
    }

    public function editModal() {



        $tableName = filter_input(INPUT_POST, "tableName");

        $colName = filter_input(INPUT_POST, "colName");


        $alldata = R::findAll($tableName);

        $this->smarty->assign('alldata', $alldata);

        $this->smarty->assign('colName', $colName);

        $this->smarty->assign('tableName', $tableName);


//	$hospitalnames = R::findall('hospitalnames');
//	$this->smarty->assign('hospitalnames', $hospitalnames);
        $this->smarty->display('instruction/editmodel.html');
    }

    public function addNewRow() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $table = filter_input(INPUT_POST, 'tableName');
        $columname = filter_input(INPUT_POST, 'colName');

        ### insert into table
        $newtable = R::xdispense($table);
        $newtable->$columname = "";

        $insertid = R::store($newtable);

        echo $insertid;
    }

    public function delRowsommedel() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        try {
            R::exec('update  ' . $tableName . ' set deleted = 1  WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

    //edit the new row of modal
    public function updateModal() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $tableName = filter_input(INPUT_POST, "tablename");
        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");

        $colName = filter_input(INPUT_POST, "colName");
        print_r($tableName);

        $mydata = R::load($tableName, $id);
        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function delhospital() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $id = filter_input(INPUT_POST, 'id');

        ### insert into table
        $hospital = R::load('hospitalnames', $id);
        R::trash($hospital);
        echo 1;
    }

    public function allinst() {
        $allInstructions = R::findall('operationinstructions', 'deleted = 0 ');
        $this->smarty->assign('alldata', $allInstructions);
        $this->smarty->display('instruction/editmodelinst.html');
    }

    public function addopinst() {

//        //check login
//        autho::checkautho($this->hosturl);
//        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $name = filter_input(INPUT_POST, 'newitem');

        //here the add
        $opInst = R::dispense('operationinstructions');

        $opInst->insttext = $name;


        try {
            $id = R::store($opInst);
            echo $id;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function editopinst() {

//        //check login
//        autho::checkautho($this->hosturl);
//        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $name = filter_input(INPUT_POST, 'newitem');

        //here the add
        $alldata = R::findAll('operationinstructions', 'deleted = 0');

        // print_r($mydata);

        $this->smarty->assign('alldata', $alldata);

        $this->smarty->display('instruction/editmodelinst.html');
    }

    public function update() {

        //check login
        //autho::checkautho($this->hosturl);
        //check authoize
        //autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $id = filter_input(INPUT_POST, "id");
        $value = filter_input(INPUT_POST, "value");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $patientId = filter_input(INPUT_POST, "patientId");

        //here the update
        $mydata = R::load($tableName, $id);

        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function delinst() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");

        $myData = R::load($tableName, $id);
        $myData->deleted = 1;
        $myid = R::store($myData);

        echo 1;
        //  header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php');
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
