<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllName;
    public $shcontrollName;
    public $active;

    // it will run in everytime with
    // default requried

    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'operation_types';
        $this->shcontrollname = 'Operation Types';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);


        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'operations'; //controller name or tab name
        $active[1] = 'operation_types'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'show';
                break;
            case 'show':
                $active[2] = 'show';
                break;
            default :
                $active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $operations_rooms = R::findAll('operations_rooms', ' deleted != 1 ');
        $this->smarty->assign('operations_rooms', $operations_rooms);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('operation_types/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $cost = filter_input(INPUT_POST, 'cost');
        $operation_time = filter_input(INPUT_POST, 'operation_time');
        $residence_time = filter_input(INPUT_POST, 'residence_time');

        if (in_array('-1', $_POST['operations_rooms'])) {
            $operations_rooms = -1;
        } else {
            $operations_rooms = implode(',', $_POST['operations_rooms']);
        }


        $operation_type = R::xdispense('detections');
        $operation_type->title = $name;
        $operation_type->detectionval = $cost;
        $operation_type->operation_time = $operation_time;
        $operation_type->residence_time = $residence_time;
        $operation_type->operations_rooms = $operations_rooms;
        $operation_type->for_operation = 1;
        $operation_type->del = 0;
        $operation_type->create_date = date('Y-m-d');
        $operation_type->cost_details = filter_input(INPUT_POST, 'cost_details');
        $operation_type->instructions = filter_input(INPUT_POST, 'instructions');
        $operation_type->sort = filter_input(INPUT_POST, 'sort');

        try {
            $id = R::store($operation_type);

            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/controllers/error?ac=notadd&id=' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //here will load the menu show
        $operation_types = R::findAll('detections', ' del != 1 and for_operation = 1 ');
        $this->smarty->assign('operation_types', $operation_types);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('operation_types/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');

        $operation_type = R::load('detections', $id);
        $operations_room_ids = explode(',', $operation_type->operations_rooms);
        $this->smarty->assign('data', $operation_type);
        $this->smarty->assign('operations_room_ids', $operations_room_ids);

        $operations_rooms = R::findAll('operations_rooms', ' deleted != 1 ');
        $this->smarty->assign('operations_rooms', $operations_rooms);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('operation_types/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $cost = filter_input(INPUT_POST, 'cost');
        $operation_time = filter_input(INPUT_POST, 'operation_time');
        $residence_time = filter_input(INPUT_POST, 'residence_time');
        if (in_array('-1', $_POST['operations_rooms'])) {
            $operations_rooms = -1;
        } else {
            $operations_rooms = implode(',', $_POST['operations_rooms']);
        }
        $id = filter_input(INPUT_POST, 'id');

        $operation_type = R::load('detections', $id);
        $operation_type->title = $name;
        $operation_type->detectionval = $cost;
        $operation_type->operation_time = $operation_time;
        $operation_type->residence_time = $residence_time;
        $operation_type->operations_rooms = $operations_rooms;
        $operation_type->for_operation = 1;
        $operation_type->cost_details = filter_input(INPUT_POST, 'cost_details');
        $operation_type->instructions = filter_input(INPUT_POST, 'instructions');
        $operation_type->sort = filter_input(INPUT_POST, 'sort');

        try {
            R::store($operation_type);

            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/controllers/error?ac=notupdate&id=' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $item_id = filter_input(INPUT_POST, 'id');
        $from_ajax = filter_input(INPUT_POST, 'fromajax');

        //load all item here
        $operation_type = R::load('detections', $item_id);
        $operation_type->del = 1;

        try {
            R::store($operation_type);
            echo '1';
        } catch (Exception $e) {
            if (!$from_ajax) {
                header('Location:' . $this->hosturl . '/controllers/error?ac=notdel&id=' . $this->controllname);
            } else {
                echo '0';
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
