<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'operativedetails';
        $this->shcontrollname = 'operativedetails';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'operativedetails'; //controller name or tab name
        $active[1] = 'operativedetails'; //controller name

        $this->active = $active;

        //    $this->patientid = patientdata::patientid();
        //$this->patientid = patientdata::patientid();
//here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }


        $this->smarty->assign('patientId', $patientid);

        $operativedetails = R::findAll('operativedetails', 'patientid = ? and del = 0 order by date desc', [$patientid]);

        foreach ($operativedetails as $operation) {
            $op = R::load('operation', $operation->operationid);
            $operation->operationName = $op->name;
            $operation->date = date('Y/m/d', strtotime($operation->date));
        }


        //send info to html
        $this->smarty->assign('operativedetails', $operativedetails);

        $this->smarty->assign('Opcount', count($operativedetails));




        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('operativedetails/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function showdata() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $today = date("Y-m-d");

        ## selected patient check
        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientid);

        ## check if there is operation

        $operationId = filter_input(INPUT_GET, "id");
        if (empty($operationId)) {
            $opData = R::dispense('operativedetails');
            $opData->date = $today;
            $opData->patientid = $patientid;
            $opData->del = 0;
            $operationId = R::store($opData);
        }
        $this->smarty->assign('today', $today);
        $this->smarty->assign('opid', $operationId);

        $this->loadone($operationId);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('operativedetails/showdata.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addnew() {
        $patientId = filter_input(INPUT_POST, "patientId");
        //check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $today = date("Y-m-d");

        $opData = R::dispense('operativedetails');
        $opData->date = $today;
        $opData->patientid = $patientId;
        $opData->del = 0;

        try {
            $opid = R::store($opData);
            echo $opid;
        } catch (Exception $e) {
            //header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function drawRow() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $operationId = filter_input(INPUT_POST, "opid");
        $itr = filter_input(INPUT_POST, "itr");


        $operativeDrugs = R::dispense('operativedetailsdrugs');
        $operativeDrugs->doctorid = $_SESSION['user_id'];
        $operativeDrugs->operationid = $operationId;
        $operativeDrugs->drugid = -1;
        $operativeDrugs->drugtype = -1;
        $operativeDrugs->deleted = 0;
        $operativeDrugs->recepittmpid = 0;
        $operativeDrugs->recepitdrugid = 0;

        $programSettingData = R::findOne("programesetting");
        $this->smarty->assign("programSettingData", $programSettingData);

        try {
            R::store($operativeDrugs);
            $drugs = R::getAll('SELECT  id , drugname , minimumbalance  FROM drugs order by drugname asc');
            $allDrugcats = R::getAll('SELECT distinct  drugcat   FROM drugs order by drugcat asc');
            $allDrugTypes = R::getAll('SELECT distinct  drugtype  FROM drugs order by drugtype asc');
            $allDrugDoses = R::getAll('SELECT distinct  drugdos   FROM drugs order by drugdos asc');


            $this->smarty->assign('operativeDrugs', $operativeDrugs);
            $this->smarty->assign('drugs', $drugs);
            $this->smarty->assign('allDrugcats', $allDrugcats);
            $this->smarty->assign('allDrugTypes', $allDrugTypes);
            $this->smarty->assign('allDrugDoses', $allDrugDoses);
            $this->smarty->assign('itr', $itr);
            $this->smarty->display('operativedetails/newrowUS.html');
        } catch (Exception $e) {
            
        }
    }

    private function loadone($operationId) {
        ## operation details
        $operativedetails = R::load('operativedetails', $operationId);
        $operativedetails->date = date("Y/m/d", strtotime($operativedetails->date));
        $this->smarty->assign('operativedetails', $operativedetails);
        $new = 0;
        ## operation drugs
        $operativeDrugs = R::findAll('operativedetailsdrugs', 'operationid = ? and deleted = ? ', [$operationId, 0]);
        if (count($operativeDrugs) < 1) {
            $new = 1;
            $operativeDrugs = R::dispense('operativedetailsdrugs');
            $operativeDrugs->doctorid = $_SESSION['user_id'];
            $operativeDrugs->operationid = $operationId;
            $operativeDrugs->drugid = -1;
            $operativeDrugs->drugtype = -1;
            $operativeDrugs->drugdos = -1;
            $operativeDrugs->deleted = 0;
            try {
                R::store($operativeDrugs);
            } catch (Exception $e) {
                
            }
        } else {
            
        }

        $operativeDrugs = R::findAll('operativedetailsdrugs', 'operationid = ?  and deleted = ? ', [$operationId, 0]);
        foreach ($operativeDrugs as $oDrug) {
            $dd = R::load('drugs', $oDrug->drugid);
            if ($dd->drugcat == '') {
                $oDrug->drugcat = -1;
            } else {
                $oDrug->drugcat = $dd->drugcat;
            }
        }
        $this->smarty->assign('new', $new);
        $this->smarty->assign('operativeDrugs', $operativeDrugs);
        $this->smarty->assign('operativeDrugsCount', count($operativeDrugs));


        #################################################################### Heba : ## Drugs Data   ##############################################################################
        ## get id and distinct drugname
        $drugs = R::getAll('select a.id , a.drugname from drugs a inner join (select distinct drugname, min(id) as id from drugs group by drugname ) as b on a.drugname = b.drugname and a.id = b.id');
        $allDrugcats = R::getAll('SELECT distinct  drugcat   FROM drugs order by drugcat asc');
        $allDrugTypes = R::getAll('SELECT distinct  drugtype  FROM drugs order by drugtype asc');
        $allDrugDoses = R::getAll('SELECT distinct  drugdos   FROM drugs order by drugdos asc');

        $this->smarty->assign('drugs', $drugs);
        $this->smarty->assign('allDrugcats', $allDrugcats);
        $this->smarty->assign('allDrugTypes', $allDrugTypes);
        $this->smarty->assign('allDrugDoses', $allDrugDoses);




        ### operation
        $operation = R::findall('operation', 'del = 0 order by name');
        $this->smarty->assign('operation', $operation);

        ### anasthesa
        $anasthesa = R::findall('anasthesa', 'del = 0 order by name');
        $this->smarty->assign('anasthesa', $anasthesa);

        ### general
        $general = R::findall('generalanasthesa', 'anasthesaid = ? and del = 0 order by name', [$operativedetails->anasthesaid]);
        $this->smarty->assign('general', $general);


        ### incision
        $jncision = R::findall('jncision', 'del = 0 order by name');
        $this->smarty->assign('jncision', $jncision);

        ### midline
        $midline = R::findall('midlinejncision', 'jncisionid = ? and del = 0 order by name', [$operativedetails->jncisionid]);
        $this->smarty->assign('midline', $midline);
        ###############################################################################################################

        $anasthesaNames1 = R::getAll('SELECT * FROM awusers WHERE role_id = ? and  specialid = ? ', [4, 3]);
        $this->smarty->assign('anasthesaNames1', $anasthesaNames1);

        $assistantNames1 = R::getAll('SELECT * FROM awusers WHERE role_id = ? and  specialid = ? ', [6, 4]);
        $this->smarty->assign('assistantNames1', $assistantNames1);


        ##########################################ta5deeeeeeeeeeeeeeeeeeeeer
        ####Anasthetists Doctors
        $anasthesaNames = R::getAll('SELECT * FROM awusers WHERE role_id = ? and  specialid = ? ', [4, 1]);

        $this->smarty->assign('anasthesaNames', $anasthesaNames);
        ####Assistant Doctors
        $assistantNames = R::getAll('SELECT * FROM awusers WHERE role_id = ? and  specialid = ? ', [6, 2]);
        $this->smarty->assign('assistantNames', $assistantNames);


        #######################################################################################################
        $outroleid = explode(",", $operativedetails->anasthetstsid);
        $this->smarty->assign('outroleid', $outroleid);

        $outroleasisid = explode(",", $operativedetails->assistantid);
        $this->smarty->assign('outroleasisid', $outroleasisid);

        $outroleanasid = explode(",", $operativedetails->anasthetsts2id);
        $this->smarty->assign('outroleanasid', $outroleanasid);

        $outroleasis2id = explode(",", $operativedetails->assistant2id);
        $this->smarty->assign('outroleasis2id', $outroleasis2id);
    }

    public function loadanasthesa() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $parentid = filter_input(INPUT_POST, 'thisvalue');

        //select table operativedetails data to order by id
        $operativedetails = R::getAll('select * from operativedetails order by id desc');



        ### general
        $general = R::getall('select * from generalanasthesa where del = 0 and anasthesaid = ' . $parentid . ' order by name');

        if (count($operativedetails) > 0) {
            //send info to html
            $this->smarty->assign('operativedetails', $operativedetails[0]);
        }

        $this->smarty->assign('general', $general);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        //$this->smarty->assign('opid', $opid);

        $this->smarty->display('operativedetails/anasthesa.html');
    }

    public function loadjncision() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $parentid = filter_input(INPUT_POST, 'thisvalue');

        //select table operativedetails data to order by id
        $operativedetails = R::getAll('select * from operativedetails order by id desc');


        ### general
        $midline = R::getall('select * from midlinejncision where del = 0 and jncisionid = ' . $parentid . ' order by name');

        if (count($operativedetails) > 0) {
            //send info to html
            $this->smarty->assign('operativedetails', $operativedetails[0]);
        }

        $this->smarty->assign('midline', $midline);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);

        $this->smarty->display('operativedetails/jncision.html');
    }

    public function addanasthesachild() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $anasthesaid = filter_input(INPUT_POST, 'anasthesa');
        $opid = filter_input(INPUT_POST, 'opid');

        ### insert into table
        $anasData = R::dispense('generalanasthesa');
        $anasData->name = $name;
        $anasData->anasthesaid = $anasthesaid;
        $anasData->del = 0;

        $insertid = R::store($anasData);

        $mainTable = R::load("operativedetails", $opid);
        $mainTable->generalid = $insertid;
        R::store($mainTable);

        echo $insertid;
    }

    public function addjncisionchild() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $jncisionid = filter_input(INPUT_POST, 'jncision');
        $opid = filter_input(INPUT_POST, 'opid');

        ### insert into table
        $newtable = R::dispense('midlinejncision');
        $newtable->name = $name;
        $newtable->jncisionid = $jncisionid;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        $mainTable = R::load("operativedetails", $opid);
        $mainTable->midlineid = $insertid;
        R::store($mainTable);

        echo $insertid;
    }

    public function addjncision() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $opid = filter_input(INPUT_POST, 'opid');

        ### insert into table
        $newtable = R::dispense('jncision');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        $mainTable = R::load("operativedetails", $opid);
        $mainTable->jncisionid = $insertid;
        R::store($mainTable);

        echo $insertid;
    }

    public function editselect() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $tableName = filter_input(INPUT_POST, "tableName");
        $patientid = filter_input(INPUT_POST, "patientid");
        $colName = filter_input(INPUT_POST, "colName");
        $mainId = filter_input(INPUT_POST, "mainId");
        $anathessid = filter_input(INPUT_POST, "anathessid");

        $alldata;
        if ($tableName == "generalanasthesa" || $tableName == "midlinejncision") {
            if ($tableName == "generalanasthesa")
                $alldata = R::findAll($tableName, 'anasthesaid = ? and del = 0 order by name', [$anathessid]);
            if ($tableName == "midlinejncision")
                $alldata = R::findAll($tableName, 'jncisionid = ? and del = 0 order by name', [$anathessid]);
        } else {
            $alldata = R::findAll($tableName, 'del = 0');
        }
        $this->smarty->assign('alldata', $alldata);
        $this->smarty->assign('patientid', $patientid);
        $this->smarty->assign('colName', $colName);
        $this->smarty->assign('mainId', $mainId);
        $this->smarty->assign('maintableName', $tableName);
        $this->smarty->assign('anathessid', $anathessid);

        $this->smarty->display('operativedetails/editmodel.html');
    }

    public function updateselect() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $tableName = filter_input(INPUT_POST, "tablename");
        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");
        $patientId = filter_input(INPUT_POST, "patientid");
        $colName = filter_input(INPUT_POST, "colName");
        $mainId = filter_input(INPUT_POST, "mainId");

        $mydata = R::load($tableName, $id);
        $mydata->name = $value;
        R::store($mydata);

        /* $mainData = R::load("operativedetails",$mainId);
          $mainData->$colName = $id;
          R::store($mainData); */


        $myalldata = R::findAll($tableName, 'del = 0');
        print_r($myalldata);
    }

    public function delRowsommedel() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $mainId = filter_input(INPUT_POST, "mainId");

        $mainData = R::load("operativedetails", $mainId);
        $mainData->$colName = 0;
        R::store($mainData);

        $myData = R::load($tableName, $id);
        $myData->del = 1;
        $myid = R::store($myData);

        echo 1;
    }

    public function delData() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, "id");
        $patientid = filter_input(INPUT_GET, "patientid");

        $myData = R::load("operativedetails", $id);
        $myData->del = 1;
        $myid = R::store($myData);

        header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
    }

    public function addselect() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $opid = filter_input(INPUT_POST, 'opid');


        ### insert into table
        $newtable = R::dispense('operation');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        $mainTable = R::load("operativedetails", $opid);
        $mainTable->operationid = $insertid;
        R::store($mainTable);

        echo $insertid;
    }

    public function addanasthesa() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $opid = filter_input(INPUT_POST, 'opid');

        ### insert into table
        $newtable = R::dispense('anasthesa');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        $mainTable = R::load("operativedetails", $opid);
        $mainTable->anasthesaid = $insertid;
        R::store($mainTable);

        echo $insertid;
    }

    public function update() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $value = filter_input(INPUT_POST, "value");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $patientId = filter_input(INPUT_POST, "patientId");
        $dated = filter_input(INPUT_POST, "dated");

        if ($dated == 1) {
            $value = date("Y-m-d", strtotime($value));
        }

        if ($tableName == 'operativedetailsdrugs') {
            $obj = R::load($tableName, $id);
            if ($colName == 'drugid') {
                if ($value != -1) {
                    $operativedetails = R::load('operativedetails', $obj->operationid);
                    switch ($obj->recepittmpid) {
                        case 0:

                            $operativeDrug = R::findOne('operativedetailsdrugs', 'operationid = ? and recepittmpid != 0 order by id desc', [$obj->operationid]);
                            ## add recept temp
                            if (count($operativeDrug) < 1) {
                                ## add pres to pharmacy to allow caching it
                                $recepittmpId = $this->addrecepittmp($operativedetails->patientid);

                                ## add recept drug element
                                $recepitdrugid = $this->addrecepitdrug($recepittmpId, $value);
                                $obj->recepitdrugid = $recepitdrugid;
                            } else {
                                $recepittmp = R::load('recepittmp', $operativeDrug->recepittmpid);
                                if ($recepittmp->status == 1) {
                                    ## add pres to pharmacy to allow caching it
                                    $recepittmpId = $this->addrecepittmp($operativedetails->patientid);

                                    ## add recept drug element
                                    $recepitdrugid = $this->addrecepitdrug($recepittmpId, $value);
                                    $obj->recepitdrugid = $recepitdrugid;
                                } else {
                                    $recepittmpId = $recepittmp->id;
                                    switch ($obj->recepitdrugid) {
                                        case 0:
                                            ## add recept drug element
                                            $recepitdrugid = $this->addrecepitdrug($recepittmpId, $value);
                                            $obj->recepitdrugid = $recepitdrugid;

                                            break;

                                        default:
                                            $recepitdrug = R::load('receiptdrugs', $obj->recepitdrugid);
                                            $recepitdrug->drugs_id = $value;
                                            R::store($recepitdrug);
                                            break;
                                    }
                                }
                            }
                            $obj->recepittmpid = $recepittmpId;

                            break;

                        default:
                            $recepittmp = R::load('recepittmp', $obj->recepittmpid);
                            if ($recepittmp->status == 1) {
                                ## add pres to pharmacy to allow caching it
                                $recepittmpId = $this->addrecepittmp($operativedetails->patientid);

                                ## add recept drug element
                                $recepitdrugid = $this->addrecepitdrug($recepittmpId, $value);
                                $obj->recepitdrugid = $recepitdrugid;
                            } else {
                                $recepittmpId = $recepittmp->id;
                                switch ($obj->recepitdrugid) {
                                    case 0:
                                        ## add recept drug element
                                        $recepitdrugid = $this->addrecepitdrug($recepittmpId, $value);
                                        $obj->recepitdrugid = $recepitdrugid;

                                        break;

                                    default:
                                        $recepitdrug = R::load('receiptdrugs', $obj->recepitdrugid);
                                        $recepitdrug->drugs_id = $value;
                                        R::store($recepitdrug);
                                        break;
                                }
                            }
                            break;
                    }
                }
            }



            $obj->$colName = $value;
            try {
                R::store($obj);
            } catch (Exception $e) {
                //header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        } else if ($tableName == 'tanks_general' || $tableName == 'colors') {
            $obj = R::load($tableName, $id);
            $obj->$colName = $value;
            R::store($obj);
        } else {
            $mydata = R::findone($tableName, 'id = ? and patientid = ?', [$id, $patientId]);
            $mydata->$colName = $value;
            R::store($mydata);
        }
    }

    private function addrecepittmp($patientid) {
        ## add pres to pharmacy to allow caching it
        $recepittmp = R::dispense('recepittmp');
        $recepittmp->doctor_id = $_SESSION['user_id'];
        $recepittmp->patient_id = $patientid;
        $recepittmp->rect_date = date("Y-m-d");
        $recepittmp->drugstablename = 'operativedetailsdrugs';
        $recepittmp->status = 0;

        $recepittmpId = R::store($recepittmp);
        return $recepittmpId;
    }

    private function addrecepitdrug($recepittmpId, $drugid) {
        ## add recept drug element

        $receiptdrugs = R::dispense('receiptdrugs');
        $receiptdrugs->drugs_id = $drugid;
        $receiptdrugs->amount = 1;
        $receiptdrugs->receipt_id = $recepittmpId;

        $recepitdrugid = R::store($receiptdrugs);
        return $recepitdrugid;
    }

    private function checkchached($recepittmpid) {
        $recepittmp = R::load('recepittmp', $recepittmpid);
        return $recepittmp->status;
    }

    public function updatecheckbox() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $value = implode(",", $_POST['value']);
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $patientId = filter_input(INPUT_POST, "patientId");

        // print_r($value);
        $mydata = R::findone($tableName, 'id = ? and patientid = ?', [$id, $patientId]);
        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function delodrug() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $id = filter_input(INPUT_POST, "id");
        $dd = R::load('operativedetailsdrugs', $id);

        $recepittmp = R::load('recepittmp', $dd->recepittmpid);
        if ($recepittmp->status == 1) {
            
        } else {
            $receiptdrugs = R::load('receiptdrugs', $dd->recepitdrugid);
            R::trash($receiptdrugs);
        }



        $dd->deleted = 1;

        try {
            R::store($dd);
            echo 1;
        } catch (Exception $e) {
            echo 22;
        }
    }

    public function addNewRow() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $table = filter_input(INPUT_POST, 'tablename');
        $fkid = filter_input(INPUT_POST, 'fkid');
        ### insert into table
        $newtable = R::dispense($table);
        $newtable->del = 0;
        if ($table == "generalanasthesa")
            $newtable->anasthesaid = $fkid;
        if ($table == "midlinejncision")
            $newtable->jncisionid = $fkid;

        $insertid = R::store($newtable);

        echo $insertid;
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
