<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $host_url;
    public $control_name;
    public $display_control_name;
    public $active;
    public $time;
    public $today;
    public $patient_id;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->host_url = $hosturl;

        $this->control_name = 'oscopic';
        $this->display_control_name = 'Oscopic';
        $this->smarty->assign('controllname', $this->control_name);
        $this->smarty->assign('shcontrollname', $this->display_control_name);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = 'oscopic';
        $active[1] = 'oscopic';
        if($acty === ''){
            $active[2] = 'oscopicadd';
        }else{
            $active[2] = 'oscopicshow';
        }

        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patient_id = patientdata::patientid();

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $patient_laparoscopic = R::findAll('patient_laparoscopic', 'patient_id = ? order by created_at desc', [$patientId]);
        $this->smarty->assign('patient_laparoscopic', $patient_laparoscopic);

        $patient_hystroscopic = R::findAll('patient_hystroscopic', 'patient_id = ?', [$patientId]);
        $this->smarty->assign('patient_hystroscopic', $patient_hystroscopic);

        $oscopic_report = R::findAll('oscopic_report', 'patient_id = ?', [$patientId]);
        $this->smarty->assign('oscopic_report', $oscopic_report);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function laparoscopic()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $laparoscopic = R::findAll('laparoscopic');
        $this->smarty->assign('laparoscopic', $laparoscopic);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/laparoscopic_add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function laparoscopicAdd()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $row = R::xdispense('patient_laparoscopic');
        $row->patient_id = $patient_id = filter_input(INPUT_POST, 'patientId');
        $row->created_at = filter_input(INPUT_POST, 'created_at');
        $row->template_id = filter_input(INPUT_POST, 'template_id');
        $row->diagnosis = implode(',',$_POST['diagnosis']);
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->uterus = filter_input(INPUT_POST, 'uterus');
        $row->uterus_procedures = filter_input(INPUT_POST, 'uterus_procedures');
        $row->right_tube = filter_input(INPUT_POST, 'right_tube');
        $row->right_tube_procedures = filter_input(INPUT_POST, 'right_tube_procedures');
        $row->left_tube = filter_input(INPUT_POST, 'left_tube');
        $row->left_tube_procedures = filter_input(INPUT_POST, 'left_tube_procedures');
        $row->right_ovary = filter_input(INPUT_POST, 'right_ovary');
        $row->right_ovary_procedures = filter_input(INPUT_POST, 'right_ovary_procedures');
        $row->left_ovary = filter_input(INPUT_POST, 'left_ovary');
        $row->left_ovary_procedures = filter_input(INPUT_POST, 'left_ovary_procedures');
        $row->uterosacrals = filter_input(INPUT_POST, 'uterosacrals');
        $row->uterosacrals_procedures = filter_input(INPUT_POST, 'uterosacrals_procedures');
        $row->peritoneum = filter_input(INPUT_POST, 'peritoneum');
        $row->peritoneum_procedures = filter_input(INPUT_POST, 'peritoneum_procedures');
        $row->recommendations = filter_input(INPUT_POST, 'recommendations');
        $row->diagnosis_text = filter_input(INPUT_POST, 'diagnosis_text');
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=index&patientid=' . $patient_id);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notadd/' . $this->control_name);
        }
    }

    public function laparoscopicEdit()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $id = filter_input(INPUT_GET, 'id');
        $patient_laparoscopic = R::load('patient_laparoscopic', $id);
        $patient_laparoscopic->diagnosis = explode(',',$patient_laparoscopic->diagnosis);
        $this->smarty->assign('patient_laparoscopic', $patient_laparoscopic);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $laparoscopic = R::findAll('laparoscopic');
        $this->smarty->assign('laparoscopic', $laparoscopic);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/laparoscopic_edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function laparoscopicUpdate()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('patient_laparoscopic', $id);
        $row->patient_id = $patient_id = filter_input(INPUT_POST, 'patientId');
        $row->created_at = filter_input(INPUT_POST, 'created_at');
        $row->template_id = filter_input(INPUT_POST, 'template_id');
        $row->diagnosis = implode(',',$_POST['diagnosis']);
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->uterus = filter_input(INPUT_POST, 'uterus');
        $row->uterus_procedures = filter_input(INPUT_POST, 'uterus_procedures');
        $row->right_tube = filter_input(INPUT_POST, 'right_tube');
        $row->right_tube_procedures = filter_input(INPUT_POST, 'right_tube_procedures');
        $row->left_tube = filter_input(INPUT_POST, 'left_tube');
        $row->left_tube_procedures = filter_input(INPUT_POST, 'left_tube_procedures');
        $row->right_ovary = filter_input(INPUT_POST, 'right_ovary');
        $row->right_ovary_procedures = filter_input(INPUT_POST, 'right_ovary_procedures');
        $row->left_ovary = filter_input(INPUT_POST, 'left_ovary');
        $row->left_ovary_procedures = filter_input(INPUT_POST, 'left_ovary_procedures');
        $row->uterosacrals = filter_input(INPUT_POST, 'uterosacrals');
        $row->uterosacrals_procedures = filter_input(INPUT_POST, 'uterosacrals_procedures');
        $row->peritoneum = filter_input(INPUT_POST, 'peritoneum');
        $row->peritoneum_procedures = filter_input(INPUT_POST, 'peritoneum_procedures');
        $row->recommendations = filter_input(INPUT_POST, 'recommendations');
        $row->diagnosis_text = filter_input(INPUT_POST, 'diagnosis_text');
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=index&patientid=' . $patient_id);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notupdate/' . $this->control_name);
        }
    }

    public function laparoscopicDel()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('patient_laparoscopic', 'id = ?', [$id]);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function laparoscopicPrint()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $id = filter_input(INPUT_GET, 'id');
        $patient_laparoscopic = R::load('patient_laparoscopic', $id);
        $patient_laparoscopic->diagnosis = explode(',',$patient_laparoscopic->diagnosis);
        $this->smarty->assign('patient_laparoscopic', $patient_laparoscopic);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $patient_info = R::findOne('patients','id = ?',[$patientId]);
        $this->smarty->assign('patient_info', $patient_info);

        $dateWife = new DateTime($patient_info->dateofbirth);
        $today1 = new DateTime(date('Y-m-d'));
        $interva2 = $today1->diff($dateWife);
        $this->smarty->assign('new_dateofbirth_calc', $interva2->y);

        $doctor_info = R::findOne('awusers','user_id = ?',[$patient_info->doctor1]);
        $this->smarty->assign('doctor_info', $doctor_info);

        $this->smarty->display('oscopic/print/laparoscopic.html');
    }

    public function hystroscopic()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $hystroscopic = R::findAll('hystroscopic');
        $this->smarty->assign('hystroscopic', $hystroscopic);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/hystroscopic_add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function hystroscopicAdd()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $row = R::xdispense('patient_hystroscopic');
        $row->patient_id = $patient_id = filter_input(INPUT_POST, 'patientId');
        $row->created_at = filter_input(INPUT_POST, 'created_at');
        $row->template_id = filter_input(INPUT_POST, 'template_id');
        $row->diagnosis = implode(',',$_POST['diagnosis']);
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->external_os = filter_input(INPUT_POST,'external_os');
        $row->external_os_procedures = filter_input(INPUT_POST,'external_os_procedures');
        $row->cervical_canal = filter_input(INPUT_POST,'cervical_canal');
        $row->cervical_canal_procedures = filter_input(INPUT_POST,'cervical_canal_procedures');
        $row->internal_os= filter_input(INPUT_POST,'internal_os');
        $row->internal_os_procedures= filter_input(INPUT_POST,'internal_os_procedures');
        $row->uterine_cavity= filter_input(INPUT_POST,'uterine_cavity');
        $row->uterine_cavity_procedures= filter_input(INPUT_POST,'uterine_cavity_procedures');
        $row->endometrium = filter_input(INPUT_POST,'endometrium');
        $row->endometrium_procedures = filter_input(INPUT_POST,'endometrium_procedures');
        $row->right_ostium = filter_input(INPUT_POST,'right_ostium');
        $row->right_ostium_procedures = filter_input(INPUT_POST,'right_ostium_procedures');
        $row->left_ostium = filter_input(INPUT_POST,'left_ostium');
        $row->left_ostium_procedures = filter_input(INPUT_POST,'left_ostium_procedures');
        $row->recommendations = filter_input(INPUT_POST, 'recommendations');
        $row->other = filter_input(INPUT_POST,'other');
        $row->other_procedures = filter_input(INPUT_POST,'other_procedures');
        $row->diagnosis_text = filter_input(INPUT_POST,'diagnosis_text');
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=index&patientid=' . $patient_id);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notadd/' . $this->control_name);
        }
    }

    public function hystroscopicEdit()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $id = filter_input(INPUT_GET, 'id');
        $patient_hystroscopic = R::load('patient_hystroscopic', $id);
        $patient_hystroscopic->diagnosis = explode(',',$patient_hystroscopic->diagnosis);
        $this->smarty->assign('patient_hystroscopic', $patient_hystroscopic);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $hystroscopic = R::findAll('hystroscopic');
        $this->smarty->assign('hystroscopic', $hystroscopic);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/hystroscopic_edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function hystroscopicUpdate()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('patient_hystroscopic', $id);
        $row->patient_id = $patient_id = filter_input(INPUT_POST, 'patientId');
        $row->created_at = filter_input(INPUT_POST, 'created_at');
        $row->template_id = filter_input(INPUT_POST, 'template_id');
        $row->diagnosis = implode(',',$_POST['diagnosis']);
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->external_os = filter_input(INPUT_POST,'external_os');
        $row->external_os_procedures = filter_input(INPUT_POST,'external_os_procedures');
        $row->cervical_canal = filter_input(INPUT_POST,'cervical_canal');
        $row->cervical_canal_procedures = filter_input(INPUT_POST,'cervical_canal_procedures');
        $row->internal_os= filter_input(INPUT_POST,'internal_os');
        $row->internal_os_procedures= filter_input(INPUT_POST,'internal_os_procedures');
        $row->uterine_cavity= filter_input(INPUT_POST,'uterine_cavity');
        $row->uterine_cavity_procedures= filter_input(INPUT_POST,'uterine_cavity_procedures');
        $row->endometrium = filter_input(INPUT_POST,'endometrium');
        $row->endometrium_procedures = filter_input(INPUT_POST,'endometrium_procedures');
        $row->right_ostium = filter_input(INPUT_POST,'right_ostium');
        $row->right_ostium_procedures = filter_input(INPUT_POST,'right_ostium_procedures');
        $row->left_ostium = filter_input(INPUT_POST,'left_ostium');
        $row->left_ostium_procedures = filter_input(INPUT_POST,'left_ostium_procedures');
        $row->recommendations = filter_input(INPUT_POST, 'recommendations');
        $row->other = filter_input(INPUT_POST,'other');
        $row->other_procedures = filter_input(INPUT_POST,'other_procedures');
        $row->diagnosis_text = filter_input(INPUT_POST,'diagnosis_text');
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=index&patientid=' . $patient_id);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notupdate/' . $this->control_name);
        }
    }

    public function hystroscopicDel()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('patient_hystroscopic', 'id = ?', [$id]);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function hystroscopicPrint()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $id = filter_input(INPUT_GET, 'id');
        $patient_hystroscopic = R::load('patient_hystroscopic', $id);
        $patient_hystroscopic->diagnosis = explode(',',$patient_hystroscopic->diagnosis);
        $this->smarty->assign('patient_hystroscopic', $patient_hystroscopic);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $patient_info = R::findOne('patients','id = ?',[$patientId]);
        $this->smarty->assign('patient_info', $patient_info);

        $dateWife = new DateTime($patient_info->dateofbirth);
        $today1 = new DateTime(date('Y-m-d'));
        $interva2 = $today1->diff($dateWife);
        $this->smarty->assign('new_dateofbirth_calc', $interva2->y);

        $doctor_info = R::findOne('awusers','user_id = ?',[$patient_info->doctor1]);
        $this->smarty->assign('doctor_info', $doctor_info);

        $this->smarty->display('oscopic/print/hystroscopic.html');
    }

    public function addToTable() {

        $name = filter_input(INPUT_POST, 'name');
        $table_name = filter_input(INPUT_POST, 'table_name');
        $new_data = R::xdispense($table_name);
        $new_data->name = $name;
        $new_data->deleted = 0;
        $inserted = R::store($new_data);
        echo $inserted;
    }

    public function editModal() {

        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $filter_input = filter_input(INPUT_POST, "filter_input");

        $all_data = R::findAll($tableName,'deleted != 1 OR deleted is NULL');
        $this->smarty->assign('all_data', $all_data);
        $this->smarty->assign('colName', $colName);
        $this->smarty->assign('tableName', $tableName);
        $this->smarty->assign('filter_input', $filter_input);
        $this->smarty->display('oscopic/edit_model.html');
    }

    public function updateModal() {

        $tableName = filter_input(INPUT_POST, "tableName");
        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");

        $colName = filter_input(INPUT_POST, "colName");

        $bean = R::load($tableName, $id);
        $bean->{$colName} = $value;
        R::store($bean);
    }

    public function deleteModelItem() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        $myData = R::load($tableName, $id);
        $myData->deleted = 1;
        R::store($myData);
        echo 1;
    }

    public function report()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $oscopic_operations = R::findall('oscopic_operations','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_operations', $oscopic_operations);

        $oscopic_required_examinations = R::findall('oscopic_required_examinations','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_required_examinations', $oscopic_required_examinations);

        $oscopic_specimens = R::findall('oscopic_specimens','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_specimens', $oscopic_specimens);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/report_add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function reportAdd()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $row = R::xdispense('oscopic_report');
        $input = $this->getFilter_input($row);
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=index&patientid=' . $input);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notadd/' . $this->control_name);
        }
    }

    public function reportEdit()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $id = filter_input(INPUT_GET, 'id');
        $oscopic_report = R::load('oscopic_report', $id);
        $oscopic_report->diagnosis = explode(',',$oscopic_report->diagnosis);
        $this->smarty->assign('oscopic_report', $oscopic_report);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $oscopic_operations = R::findall('oscopic_operations','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_operations', $oscopic_operations);

        $oscopic_required_examinations = R::findall('oscopic_required_examinations','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_required_examinations', $oscopic_required_examinations);

        $oscopic_specimens = R::findall('oscopic_specimens','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_specimens', $oscopic_specimens);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        patientdata::patientdatashow($this->smarty, $this->host_url);
        $this->smarty->display('oscopic/report_edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function reportUpdate()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('oscopic_report', $id);
        $input = $this->getFilter_input($row);
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=index&patientid=' . $input);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notupdate/' . $this->control_name);
        }
    }

    public function reportDel()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('oscopic_report', 'id = ?', [$id]);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function reportPrint()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        if (empty($patientId = filter_input(INPUT_GET, "patientid"))) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientId);

        $id = filter_input(INPUT_GET, 'id');
        $oscopic_report = R::load('oscopic_report', $id);
        $oscopic_report->diagnosis = explode(',',$oscopic_report->diagnosis);
        $this->smarty->assign('oscopic_report', $oscopic_report);

        $allDiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('allDiagnosis', $allDiagnosis);

        $oscopic_operations = R::findall('oscopic_operations','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_operations', $oscopic_operations);

        $oscopic_required_examinations = R::findall('oscopic_required_examinations','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_required_examinations', $oscopic_required_examinations);

        $oscopic_specimens = R::findall('oscopic_specimens','deleted != 1 OR deleted is NULL');
        $this->smarty->assign('oscopic_specimens', $oscopic_specimens);

        $patient_info = R::findOne('patients','id = ?',[$patientId]);
        $this->smarty->assign('patient_info', $patient_info);

        $today1 = new DateTime(date('Y-m-d'));
        if($oscopic_report->husband === '1'){
            $date_husband = new DateTime($patient_info->husbanddateofbirth);
            $interva2 = $today1->diff($date_husband);
        }else{
            $dateWife = new DateTime($patient_info->dateofbirth);
            $interva2 = $today1->diff($dateWife);
        }
        $this->smarty->assign('new_dateofbirth_calc', $interva2->y);


        if($oscopic_report->husband === '1'){
            $doctor_id = $patient_info->h_doctor1;
        }else{
            $doctor_id = $patient_info->doctor1;
        }

        $doctor_info = R::findOne('awusers','user_id = ?',[$doctor_id]);
        $this->smarty->assign('doctor_info', $doctor_info);

        $this->smarty->display('oscopic/print/report.html');
    }

    public function __destruct()
    {
        R::close();
    }

    /**
     * @param $row
     * @return mixed
     */
    protected function getFilter_input($row)
    {
        $row->patient_id = $input = filter_input(INPUT_POST, 'patientId');
        $row->created_at = filter_input(INPUT_POST, 'created_at');
        $row->diagnosis = implode(',', $_POST['diagnosis']);
        $row->operation_id = filter_input(INPUT_POST, 'operation_id');
        $row->operation_text = filter_input(INPUT_POST, 'operation_text');
        $row->required_examination_id = filter_input(INPUT_POST, 'required_examination_id');
        $row->required_examination_text = filter_input(INPUT_POST, 'required_examination_text');
        $row->specimen_id = filter_input(INPUT_POST, 'specimen_id');
        $row->specimen_text = filter_input(INPUT_POST, 'specimen_text');
        $row->diagnosis_text = filter_input(INPUT_POST, 'diagnosis_text');
        $row->husband = filter_input(INPUT_POST, 'husband');
        return $input;
    }

}
