<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllName;
    public $shcontrollName;
    public $active;

    // it will run in everytime with
    // default requried

    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'residence_rooms';
        $this->shcontrollname = 'Residence Rooms';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);


# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'operations'; //controller name or tab name
        $active[1] = 'residence_rooms'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'show';
                break;
            case 'show':
                $active[2] = 'show';
                break;
            default :
                $active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

//here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $floors = R::findAll('floors', ' deleted != 1 ');
        $this->smarty->assign('floors', $floors);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('residence_rooms/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $start_time = filter_input(INPUT_POST, 'start_time');
        $end_time = filter_input(INPUT_POST, 'end_time');
        $floor_no = filter_input(INPUT_POST, 'floor_no');

        $residence_room = R::xdispense('residence_rooms');
        $residence_room->name = $name;
        $residence_room->start_time = $start_time;
        $residence_room->end_time = $end_time;
        $residence_room->create_date = date('Y-m-d');
        $residence_room->deleted = 0;
        $residence_room->floor_no = $floor_no;

        try {
            $id = R::store($residence_room);

            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/controllers/error?ac=notadd&id=' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //here will load the menu show
        $residence_rooms = R::findAll('residence_rooms', ' deleted != 1 ');
        $this->smarty->assign('residence_rooms', $residence_rooms);

        $this->smarty->assign('tableName', 'residence_rooms');


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('residence_rooms/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');

        $residence_room = R::load('residence_rooms', $id);
        $this->smarty->assign('data', $residence_room);

        $floors = R::findAll('floors', ' deleted != 1 ');
        $this->smarty->assign('floors', $floors);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('residence_rooms/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $start_time = filter_input(INPUT_POST, 'start_time');
        $end_time = filter_input(INPUT_POST, 'end_time');
        $floor_no = filter_input(INPUT_POST, 'floor_no');
        $id = filter_input(INPUT_POST, 'id');

//        $image = uploadupdate('file', 'imageurl', False, 0, 0, 'blog');


        $residence_room = R::load('residence_rooms', $id);
        $residence_room->name = $name;
        $residence_room->start_time = $start_time;
        $residence_room->end_time = $end_time;
        $residence_room->floor_no = $floor_no;

        try {
            R::store($residence_room);

            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/controllers/error?ac=notupdate&id=' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $item_id = filter_input(INPUT_POST, 'id');
        $from_ajax = filter_input(INPUT_POST, 'fromajax');

        //load all item here
        $residence_room = R::load('residence_rooms', $item_id);
        $residence_room->deleted = 1;

        try {
            R::store($residence_room);
            echo '1';
        } catch (Exception $e) {
            if (!$from_ajax) {
                header('Location:' . $this->hosturl . '/controllers/error?ac=notdel&id=' . $this->controllname);
            } else {
                echo '0';
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
