<?php

require_once("imp/_imp.php");

class Controllers
{

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'tanks';
        $this->shcontrollname = 'tanks';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);


        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'tanks'; //controller name or tab name
        $active[1] = 'tanks'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'tanksadd';
                break;
            case 'show':
                $active[2] = 'tanksshow';
                break;
            default :
                $active[2] = 'tanksshow';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('tanks/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $tank_type = filter_input(INPUT_POST, 'tank_type');

        //here the add
        $tank = R::dispense('tanks');

        $tank->name = $name;
        $tank->tank_type = $tank_type;
        try {
            R::begin();

            $id = R::store($tank);
            // create cells in tanks cells
            if ((int)$tank_type === 1 || (int)$tank_type === 2) {
                // 200 cell
                for ($i = 1; $i <= 10; $i++) {
                    for ($x = 1; $x <= 20; $x++) {
                        for ($y = 1; $y <= 5; $y++) {
                            $tank_cell = R::dispense('tankcells');
                            $tank_cell->tank_id = $id;
                            $tank_cell->up_level_name = $i;
                            $tank_cell->cell_name = $x;
                            $tank_cell->cell_part_name = $y;
                            $tank_cell->patient_id = 0;
                            $tank_cell->created_at = date('Y-m-d H:i:s');
                            R::store($tank_cell);
                        }
                    }
                }
            }
            R::commit();

            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show()
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //load all parents here
        $tanks = R::findAll('tanks');
        $this->smarty->assign('tanks', $tanks);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('tanks/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit()
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");

        //load all here
        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('tanks/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function cells()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");

        //load all here
        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        if ((int)$tank->tank_type === 1) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tankcells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tankcells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tankcells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                    if ($sec_level_full > 0) {
                        ++$leve_full;
                    }

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 20);
        }

        if ((int)$tank->tank_type === 2) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tankcells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tankcells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tankcells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            ++$leve_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 100);
        }

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('tanks/cells.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update()
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $tank_type = filter_input(INPUT_POST, 'tank_type');

        $id = filter_input(INPUT_POST, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);


        //here the update
        $tank = R::load('tanks', $id);

        $tank->name = $name;
        //$tank->tank_type = $tank_type;

        try {
            R::store($tank);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del()
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authorize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $tank = R::findOne('tanks', 'id = ?', [$id]);
            R::trash($tank);
            $tank_cells = R::findAll('tankcells', 'tank_id = ?', [$id]);
            R::trashAll($tank_cells);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function removePatientCell()
    {

        //check login
        autho::checkautho($this->hosturl);

        $cell_id = filter_input(INPUT_POST, 'cell_id');

        try {
            $remove = R::findOne('tankcells', 'id = ?', [$cell_id]);
            if ($remove) {

                // add to history
                $cell_history = R::dispense('tankcellhistory');
                $cell_history->tank_id = $remove->tank_id;
                $cell_history->cell_id = $remove->id;
                $cell_history->patient_id = $remove->patient_id;
                $cell_history->action_type = 'Remove patient';
                $cell_history->done_date = date('Y-m-d H:i:s');
                $cell_history->by_user_id = $_SESSION['user_id'];
                R::store($cell_history);


                $remove->patient_id = 0;
                R::store($remove);
                echo true;
            } else {
                echo false;
            }

        } catch (Exception $exception) {
            echo false;
        }
    }

    public function tankLabCells()
    {

        //check login
        autho::checkautho($this->hosturl);

        //get id for item
        $id = filter_input(INPUT_POST, 'tank_id');
        $patient_id = filter_input(INPUT_POST, "patient_id");

        //load all here
        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        if ((int)$tank->tank_type === 1) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tankcells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tankcells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tankcells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                    if ($sec_level_full > 0) {
                        ++$leve_full;
                    }

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
                //$tank_cells[] = $level;
            }
            unset($level);
            //print_r($tank_cells);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 20);
        }

        if ((int)$tank->tank_type === 2) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tankcells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tankcells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tankcells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            ++$leve_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 100);
        }


        $this->smarty->display('tanks/lab_cells.html');
    }

    public function saveTankLabCell()
    {
        //check login
        autho::checkautho($this->hosturl);

        $tank_id = filter_input(INPUT_POST, 'lab_tank_id');
        $up_level_name = filter_input(INPUT_POST, 'up_level_name');
        $cell_name = filter_input(INPUT_POST, 'cell_name');
        $lab_patient_id = filter_input(INPUT_POST, 'lab_patient_id');
        $last_cells = $_POST['last_cell'];

        //print_r("tank id = $tank_id --> up level = $up_level_name --> cell name = $cell_name --> last level = $last_cell --> patient id = $lab_patient_id");

        $return = false;
        foreach ($last_cells as $cell) {
            $tank_cell = R::findOne('tankcells', 'tank_id = ? AND up_level_name = ? AND cell_name = ? AND cell_part_name = ?', [$tank_id, $up_level_name, $cell_name, $cell]);
            if ($tank_cell->patient_id < 1) {
                $tank_cell->patient_id = $lab_patient_id;
                R::store($tank_cell);
                $return = true;


                // add to history
                $cell_history = R::dispense('tankcellhistory');
                $cell_history->tank_id = $tank_id;
                $cell_history->cell_id = $tank_cell->id;
                $cell_history->patient_id = $lab_patient_id;
                $cell_history->action_type = 'Add patient';
                $cell_history->done_date = date('Y-m-d H:i:s');
                $cell_history->by_user_id = $_SESSION['user_id'];
                R::store($cell_history);
            }
        }

        echo $return;

    }

    // at the end of class call
    public function __destruct()
    {
        //colse connection
        R::close();
    }

}
