<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php");
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        $this->controllname = 'vote';
        $this->shcontrollname = 'Vote';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = $this->controllname;
        $active[1] = $this->controllname;
        switch ($acty) {
            case '':
                $active[2] = $this->controllname . 'add';
                break;
            default :
                $active[2] = $this->controllname . 'show';
                break;
        }
        $this->active = $active;

        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $vote_devices = R::findAll('vote_devices');
        $this->smarty->assign('vote_devices', $vote_devices);

        $roles = R::findAll('awrole');
        $this->smarty->assign('roles', $roles);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote/add.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function removeQuestion()
    {
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, 'question_id');
        try {
            $question = R::load('vote_questions', $id);
            $answers = R::findAll('vote_answers', 'vote_question_id = ?', [$id]);
            R::trashAll($answers);
            R::trash($question);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function add()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        try {

            $row = R::xdispense('votes');
            $row->vote_device_id = filter_input(INPUT_POST, 'vote_device_id');
            $row->voter_required = filter_input(INPUT_POST, 'voter_required');
            $row->email = filter_input(INPUT_POST, 'email');
            $row->role_id = filter_input(INPUT_POST, 'role_id');
            $row->created_at = date('Y-m-d H:i:s');
            $row->updated_at = date('Y-m-d H:i:s');
            $id = R::store($row);

            $vote_questions_itr = filter_input(INPUT_POST, 'vote_questions_itr');
            for ($i = 1; $i <= $vote_questions_itr; $i++) {
                $question_content = filter_input(INPUT_POST, 'question_' . $i);
                if (empty($question_content)) {
                    continue;
                }
                $question = R::xdispense('vote_questions');
                $question->vote_id = $id;
                $question->question = $question_content;
                $question->created_at = date('Y-m-d H:i:s');
                $question->updated_at = date('Y-m-d H:i:s');
                $question_id = R::store($question);

                for ($j = 1; $j <= 5; $j++) {
                    $answer_content = filter_input(INPUT_POST, 'answer_' . $j . '_' . $i);
                    if (empty($answer_content)) {
                        continue;
                    }
                    $answer = R::xdispense('vote_answers');
                    $answer->vote_question_id = $question_id;
                    $answer->answer = filter_input(INPUT_POST, 'answer_' . $j . '_' . $i);
                    $answer->send_mail = filter_input(INPUT_POST, 'send_mail_' . $j . '_' . $i);
                    $answer->face = filter_input(INPUT_POST, 'face_' . $j . '_' . $i);
                    $answer->created_at = date('Y-m-d H:i:s');
                    $answer->updated_at = date('Y-m-d H:i:s');
                    R::store($answer);
                }
            }
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $votes = R::findAll('votes');
        foreach ($votes as $vote) {
            //role
            $role = R::findOne('awrole', 'id = ?', [$vote->role_id]);
            $vote->role_name = $role->name;
            // vote device
            $vote_device = R::findOne('vote_devices', 'id = ?', [$vote->vote_device_id]);
            $vote->vote_device_name = $vote_device->name;
        }
        $this->smarty->assign('votes', $votes);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote/show.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $vote_devices = R::findAll('vote_devices');
        $this->smarty->assign('vote_devices', $vote_devices);

        $roles = R::findAll('awrole');
        $this->smarty->assign('roles', $roles);

        $id = filter_input(INPUT_GET, 'id');
        $vote = R::load('votes', $id);
        $this->smarty->assign('vote', $vote);

        $questions = R::findAll('vote_questions', 'vote_id = ?', [$id]);
        foreach ($questions as $question) {
            $answers = R::getAll('select * from vote_answers where vote_question_id = ?', [$question->id]);
            $question->answers = $answers;
        }
        $this->smarty->assign('questions', $questions);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote/edit.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        try {
            $row = R::load('votes', $id);
            $row->vote_device_id = filter_input(INPUT_POST, 'vote_device_id');
            $row->voter_required = filter_input(INPUT_POST, 'voter_required');
            $row->email = filter_input(INPUT_POST, 'email');
            $row->role_id = filter_input(INPUT_POST, 'role_id');
            $row->updated_at = date('Y-m-d H:i:s');
            R::store($row);

            $vote_questions_itr = filter_input(INPUT_POST, 'vote_questions_itr');
            for ($i = 1; $i <= $vote_questions_itr; $i++) {
                $question_id = filter_input(INPUT_POST, 'question_id_' . $i);
                $question_content = filter_input(INPUT_POST, 'question_' . $i);
                if (empty($question_content)) {
                    continue;
                }
                if (empty($question_id)) {
                    $question = R::xdispense('vote_questions');
                    $question->created_at = date('Y-m-d H:i:s');
                } else {
                    $question = R::load('vote_questions', $question_id);
                }
                $question->vote_id = $id;
                $question->question = $question_content;
                $question->updated_at = date('Y-m-d H:i:s');
                if (empty($question_id)) {
                    $question_id = R::store($question);
                } else {
                    R::store($question);
                }

                for ($j = 1; $j <= 5; $j++) {
                    $answer_id = filter_input(INPUT_POST, 'answer_id_' . $j . '_' . $i);
                    $answer_content = filter_input(INPUT_POST, 'answer_' . $j . '_' . $i);
                    if (empty($answer_content) && empty($answer_id)) {
                        continue;
                    }
                    if (empty($answer_id)) {
                        $answer = R::xdispense('vote_answers');
                        $answer->created_at = date('Y-m-d H:i:s');
                    } else {
                        $answer = R::load('vote_answers', $answer_id);
                    }
                    $answer->vote_question_id = $question_id;
                    $answer->answer = filter_input(INPUT_POST, 'answer_' . $j . '_' . $i);
                    $answer->send_mail = filter_input(INPUT_POST, 'send_mail_' . $j . '_' . $i);
                    $answer->face = filter_input(INPUT_POST, 'face_' . $j . '_' . $i);
                    $answer->updated_at = date('Y-m-d H:i:s');
                    R::store($answer);
                }
            }
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('votes', 'id = ?', [$id]);
            //check if vote is used in client votes
            $client_votes = R::find('client_votes', 'vote_id = ?', [$id]);
            if (!empty($client_votes)) {
                echo 0;
                return;
            }
            // trash vote questions and answers
            $questions = R::find('vote_questions', 'vote_id = ?', [$id]);
            foreach ($questions as $question) {
                $answers = R::find('vote_answers', 'vote_question_id = ?', [$question->id]);
                R::trashAll($answers);
            }
            R::trashAll($questions);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function report()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $roles = R::findAll('awrole');
        $this->smarty->assign('roles', $roles);

        $role_id = filter_input(INPUT_POST, 'role_id');
        $this->smarty->assign('role_id', $role_id);
        if ($role_id) {
            $votes = R::findAll('votes', 'role_id = ?', [$role_id]);
            $device_ids = array();
            foreach ($votes as $vote) {
                $device_ids[] = $vote->vote_device_id;
            }
            $device_ids = array_unique($device_ids);
            if (!empty($device_ids)) {
                // get unique user id  from clients votes table with device id
                $client_votes = R::findAll('clients_votes', 'vote_device_id IN (' . implode(',', $device_ids) . ')');
                $user_ids = array();
                foreach ($client_votes as $client_vote) {
                    $user_ids[] = $client_vote->user_id;
                }
                $user_ids = array_unique($user_ids);
                if (!empty($user_ids)) {
                    $users = R::getAll('SELECT user_id,name FROM awusers WHERE user_id IN (' . implode(',', $user_ids) . ')');
                    $users_votes = array();
                    foreach ($users as $user) {
                        $users_votes[] = array(
                            'user_id' => $user['user_id'],
                            'name' => $user['name'],
                            'votes' => R::count('clients_votes', ' user_id = ?', [$user['user_id']]),
                            'last_vote_date' => R::getCell('SELECT MAX(created_at) FROM clients_votes WHERE user_id = ?', [$user['user_id']])
                        );
                    }

                    $this->smarty->assign('users_votes', $users_votes);
                }

            }

        }

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote/report.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function reportDetails()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $user_id = filter_input(INPUT_GET, 'id');
        $this->smarty->assign('user_id', $user_id);
        if ($user_id) {

            $user_info = R::findOne('awusers', 'user_id = ?', [$user_id]);
            $this->smarty->assign('user_info', $user_info);

            $votes = R::findAll('clients_votes', 'user_id = ? order by created_at desc', [$user_id]);
            foreach ($votes as $vote) {
                $clients_vote_answers = R::findAll('clients_votes_answers', 'client_vote_id = ?', [$vote->id]);
                foreach ($clients_vote_answers as $clients_vote_answer) {
                    $clients_vote_answer->question = R::findOne('vote_questions', 'id = ?', [$clients_vote_answer->question_id]);
                }
                $vote->answers = $clients_vote_answers;
            }
            $this->smarty->assign('votes', $votes);

            $count_votes = R::count('clients_votes', 'user_id = ?', [$user_id]);
            $this->smarty->assign('count_votes', $count_votes);

            $count_question = R::getCol('SELECT COUNT(DISTINCT question_id) as count_question FROM clients_votes_answers WHERE client_vote_id IN (SELECT id FROM clients_votes WHERE user_id = ?)', [$user_id]);
            $this->smarty->assign('count_question', $count_question);

            $count_answer = R::getCol('SELECT COUNT(answer_id) as count_answer FROM clients_votes_answers WHERE client_vote_id IN (SELECT id FROM clients_votes WHERE user_id = ?)', [$user_id]);
            $this->smarty->assign('count_answer', $count_answer);

            $count_answer_text = R::getAll('SELECT COUNT(answer_id)AS count_answer,answer_text FROM clients_votes_answers WHERE client_vote_id IN(SELECT id FROM clients_votes WHERE user_id=?)Group By answer_text', [$user_id]);
            $this->smarty->assign('count_answer_text', $count_answer_text);
        }

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote/report_details.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function empReport()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $roles = R::findAll('awrole');
        $this->smarty->assign('roles', $roles);
        $this->smarty->assign('today', date('Y-m-d'));

        // get role valid id
        $role_id = filter_input(INPUT_POST, 'role_id');
        $this->smarty->assign('role_id', $role_id);
        $from_date = filter_input(INPUT_POST, 'from_date') ?: date('Y-m-d');
        $to_date = filter_input(INPUT_POST, 'to_date') ?: date('Y-m-d');
        $this->smarty->assign('search_dates', [
            'from_date' => $from_date,
            'to_date' => $to_date
        ]);


        if ($role_id) {
            $votes = R::findAll('votes', 'role_id = ?', [$role_id]);
            // get devices id unique from votes table
            $device_ids = [];
            foreach ($votes as $vote) {
                $device_ids[] = $vote->vote_device_id;
            }
            $device_ids = array_unique($device_ids);

            // check for not empty device_ids
            if (!empty($device_ids)) {
                // get unique user id  from clients votes table with device id
                $client_votes = R::findAll('clients_votes', '(DATE(created_at) BETWEEN ? AND ?) AND (vote_device_id IN (' . implode(',', $device_ids) . '))', [$from_date, $to_date]);

                $user_ids = [];
                foreach ($client_votes as $client_vote) {
                    $user_ids[] = $client_vote->user_id;
                }
                $user_ids = array_unique($user_ids);

                if (!empty($user_ids)) {
                    $users_info = R::getAll('SELECT user_id,name FROM awusers WHERE user_id IN (' . implode(',', $user_ids) . ')');
                    foreach ($users_info as &$user_info) {
                        $count_votes = R::count('clients_votes', '(DATE(created_at) BETWEEN ? AND ?) AND user_id = ?', [$from_date, $to_date, $user_info['user_id']]);
                        $user_info['count_votes'] = $count_votes;

                        /* $count_question = R::getCol('SELECT COUNT(DISTINCT question_id) as count_question FROM clients_votes_answers WHERE client_vote_id IN (SELECT id FROM clients_votes WHERE user_id = ?)', [$user_info['user_id']]);
                         $user_info['count_question'] = $count_question;*/

                        $count_answer = R::getCol('SELECT COUNT(answer_id) as count_answer FROM clients_votes_answers WHERE (DATE(created_at) BETWEEN ? AND ?) AND client_vote_id IN (SELECT id FROM clients_votes WHERE user_id = ?)', [$from_date, $to_date, $user_info['user_id']]);
                        $user_info['count_answer'] = $count_answer;

                        list($count_answer_text, $user_info) = $this->countAnswerOrdered($from_date, $to_date, $user_info);
                    }
                    unset($user_info);
                    $this->smarty->assign('users_info', $users_info);
                }
            }
        }

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote/emp_report.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);

    }

    public function updateClientVoteContact()
    {
        $client_vote_id = filter_input(INPUT_POST, 'vote_id');
        $is_contact = filter_input(INPUT_POST, 'is_contact');

        try {
            $client_vote = R::load('clients_votes', $client_vote_id);
            $client_vote->is_contact = $is_contact;
            R::store($client_vote);
            echo json_encode(['success' => true]);
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        }

    }

    public function updateVoteReply(){
        $client_vote_id = filter_input(INPUT_POST, 'vote_id');
        $reply = filter_input(INPUT_POST, 'reply');

        try {
            $client_vote = R::load('clients_votes', $client_vote_id);
            $client_vote->reply = $reply;
            R::store($client_vote);
            echo json_encode(['success' => true]);
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    public function __destruct()
    {
        R::close();
    }

    /**
     * @param $from_date
     * @param $to_date
     * @param $user_info
     * @return array
     */
    protected function countAnswerOrdered($from_date, $to_date, $user_info)
    {
        $count_answer_text = R::getAll('SELECT COUNT(answer_id)AS count_answer,answer_text FROM clients_votes_answers WHERE (DATE(created_at) BETWEEN ? AND ?) AND client_vote_id IN(SELECT id FROM clients_votes WHERE user_id=?)Group By answer_text', [$from_date, $to_date, $user_info['user_id']]);
        $order = ['ممتاز', 'جيد', 'مقبول', 'غير راضي'];

        $default_values = [
            ['answer_text' => 'ممتاز'],
            ['answer_text' => 'جيد'],
            ['answer_text' => 'مقبول'],
            ['answer_text' => 'غير راضي']
        ];

        $interact_options = array_intersect(array_column($default_values, 'answer_text'), array_column($count_answer_text, 'answer_text'));
        // get items not in array order with interact options and add to count_answer_text
        $count_answer_diff = array_diff($order, $interact_options);
        foreach ($count_answer_diff as $count_answer_text_item) {
            $count_answer_text[] = ['answer_text' => $count_answer_text_item, 'count_answer' => 0];
        }

        usort($count_answer_text, function ($a, $b) use ($order) {
            $a = array_search($a["answer_text"], $order);
            $b = array_search($b["answer_text"], $order);
            if ($a === false && $b === false) { // both items are don't care
                return 0;                       // a == b
            } else if ($a === false) {          // $a is a dont care
                return 1;                       // $a > $b
            } else if ($b === false) {          // $b is a dont care
                return -1;                      // $a < $b
            } else {
                return $a - $b;                 // sort $a and $b ascending
            }
        });

        $user_info['count_answer_text'] = array_reverse($count_answer_text);
        return array($count_answer_text, $user_info);
    }

}
