<div class="row">
    <div class="col-md-12">
        {if $template_data->header_print != 'no image' || !empty($template_data->header_print)}
            <img src="{$hosturl}/../upload/colonoscopy_template/{$template_data->header_print}" class="img-thumbnail" alt="">
        {/if}
    </div>
    <div class="col-md-12">
        <h2 class="text-center" style="color: #935b61;font-weight: 600;font-size: 38px;">Colonoscopy</h2>
    </div>

    <div class="col-md-12">
        <table class="table">
            <tr>
                <th>Patient name</th>
                <th>ID</th>
                <th>Age</th>
                <th>Sex</th>
                <th>Exam date</th>
                <th>Referral</th>
            </tr>
            <tr>
                <td>{$patientInfo->wifename}</td>
                <td>{$patientInfo->statusno}</td>
                <td>{$new_age_calc}</td>
                <td>-</td>
                <td>{$edit_data->exam_date}</td>
                <td>{$refer_doctor->name}</td>
            </tr>
        </table>
    </div>

    <div class="col-md-9">
        <div class="row">
            <div class="col-md-12">
                <table class="table table-borderless">
                    <tbody>
                    <tr>
                        <td style="width: 15%">Indication</td>
                        <td>{$edit_data->indication}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Consent</td>
                        <td>{$edit_data->consent}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Preparation</td>
                        <td>{$edit_data->preparation}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Instrument</td>
                        <td>{$edit_data->instrument}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Anesthesia</td>
                        <td>{$edit_data->anesthesia}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Procedure</td>
                        <td>{$edit_data->procedure}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Preparation</td>
                        <td>{$edit_data->preparation_2}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Withdrawal time</td>
                        <td>{$edit_data->withdrawal_time}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">DRE</td>
                        <td>{$edit_data->dre}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">Findings</td>
                        <td>{$edit_data->findings}</td>
                    </tr>
                    <tr>
                        <td style="width: 15%">PLan</td>
                        <td>{$edit_data->pLan}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-md-12 text-center">
                <h4>Signature</h4>
                <h2 style="color: darkred;font-weight: bold;">{$edit_data->signature}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        {foreach $colonoscopy_images as $single}
            <div class="row">
                <div class="col-md-12" style="margin-bottom: 3px;">
                    <img src="{$hosturl}/../upload/colonoscopy/{$single->image}" class="img-responsive">
                </div>
            </div>
        {/foreach}
    </div>
    <div class="col-md-12">
        {if $template_data->footer_print != 'no image' || !empty($template_data->footer_print)}
            <img src="{$hosturl}/../upload/colonoscopy_template/{$template_data->footer_print}" class="img-thumbnail" alt="">
        {/if}
    </div>
</div>


<style>
    .col-md-12 {
        width: 100%;
    }

    .img-responsive {
        display: block;
        max-width: 100%;
        height: auto;
    }

    img {
        vertical-align: middle;
        border: 0;
    }
    .col-md-1, .col-md-10, .col-md-11, .col-md-12, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9 {
        float: left;
    }
    .col-lg-1, .col-lg-10, .col-lg-11, .col-lg-12, .col-lg-2, .col-lg-3, .col-lg-4, .col-lg-5, .col-lg-6, .col-lg-7, .col-lg-8, .col-lg-9, .col-md-1, .col-md-10, .col-md-11, .col-md-12, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9, .col-sm-1, .col-sm-10, .col-sm-11, .col-sm-12, .col-sm-2, .col-sm-3, .col-sm-4, .col-sm-5, .col-sm-6, .col-sm-7, .col-sm-8, .col-sm-9, .col-xs-1, .col-xs-10, .col-xs-11, .col-xs-12, .col-xs-2, .col-xs-3, .col-xs-4, .col-xs-5, .col-xs-6, .col-xs-7, .col-xs-8, .col-xs-9 {
        position: relative;
        min-height: 1px;
        padding-right: 0;
        padding-left: 0;
    }
    .col-md-9 {
        width: 75%;
    }
    .col-md-3 {
        width: 25%;
    }
</style>