<!DOCTYPE html>
<html lang="en">
<head>
    <title>Floor Rooms</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--===============================================================================================-->
    <link rel="icon" type="image/png" href="{$path}/room_rp/images/icons/favicon.ico"/>
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/vendor/bootstrap/css/bootstrap.min.css">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/fonts/font-awesome-4.7.0/css/font-awesome.min.css">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/vendor/animate/animate.css">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/vendor/select2/select2.min.css">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/vendor/perfect-scrollbar/perfect-scrollbar.css">
    <!--===============================================================================================-->
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/css/util.css">
    <link rel="stylesheet" type="text/css" href="{$path}/room_rp/css/main.css">
    <!--===============================================================================================-->
    <style>
        body {
            direction: rtl;
        }

        .table100-head th {
            text-align: center;
        }

        table td, table th {
            text-align: center;
        }
        .wrap-table100 {
            width: 100%;
        }
        table td, table th {
            color: #000;
            font-weight: bolder;
        }
        table tbody tr {
            height: 70px;
        }
    </style>
</head>
<body>

<div class="limiter">
    <div class="container-table100">
        <div class="wrap-table100">
            <div class="table100">
                <table>
                    <thead>
                    <tr class="table100-head">
                        <th>رقم الغرفة</th>
                        <th>رقم المريض</th>
                        <th>اسم المريض</th>
                        <th>الطبيب المعالج</th>
                        <th>العملية</th>
                        <th>دخول العملية</th>
                        <th>خروج العملية</th>
                        <th>وقت الدخول</th>
                        <th>وقت الخروج</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach $residence_rooms as $room}
                        <tr>
                            <td>{$room->name}</td>
                            <td>{$room->patient_id} </td>
                            <td>{$room->patient_name} </td>
                            <td>{$room->doctor_name}  </td>
                            <td>{$room->op_type} </td>
                            <td>{$room->op_enter_time} </td>
                            <td>{$room->op_exit_time} </td>
                            <td>{$room->enter_time} </td>
                            <td>{$room->exit_time}</td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<!--===============================================================================================-->
<script src="{$path}/room_rp/vendor/jquery/jquery-3.2.1.min.js"></script>
<!--===============================================================================================-->
<script src="{$path}/room_rp/vendor/bootstrap/js/popper.js"></script>
<script src="{$path}/room_rp/vendor/bootstrap/js/bootstrap.min.js"></script>
<!--===============================================================================================-->
<script src="{$path}/room_rp/vendor/select2/select2.min.js"></script>
<!--===============================================================================================-->
<script src="{$path}/room_rp/js/main.js"></script>

<script>
    let table = $("table tr");
    table.hide();
    table.each(function (index) {
        $(this).delay(index * 250).show(500);
    });

    setInterval(function () {
        window.location.reload();
    }, 60000);
</script>

</body>
</html>
